/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.http.jetty;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.cache.VisorCacheKeyObject;
import org.apache.ignite.internal.visor.cache.VisorDataType;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;

public class GridJettyObjectMapper
extends ObjectMapper {
    private static final JsonSerializer<Object> NULL_KEY_SERIALIZER = new JsonSerializer<Object>(){

        public void serialize(Object val, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeFieldName("");
        }
    };
    private static final JsonSerializer<Object> NULL_VALUE_SERIALIZER = new JsonSerializer<Object>(){

        public void serialize(Object val, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeNull();
        }
    };
    private static final JsonDeserializer<VisorCacheKeyObject> VISOR_CACHE_KEY_OBJECT_DESERIALIZER = new JsonDeserializer<VisorCacheKeyObject>(){

        private Object strToObject(VisorDataType type, String o) {
            switch (type) {
                case STRING: {
                    return o;
                }
                case CHARACTER: {
                    return Character.valueOf(o.charAt(0));
                }
                case BYTE: {
                    return Byte.valueOf(o);
                }
                case SHORT: {
                    return Short.valueOf(o);
                }
                case INT: {
                    return Integer.valueOf(o);
                }
                case LONG: {
                    return Long.valueOf(o);
                }
                case FLOAT: {
                    return Float.valueOf(o);
                }
                case DOUBLE: {
                    return Double.valueOf(o);
                }
                case BOOLEAN: {
                    return Boolean.valueOf(o);
                }
                case UUID: {
                    return UUID.fromString(o);
                }
                case TIMESTAMP: {
                    return new Timestamp(Long.parseLong(o));
                }
                case DATE_UTIL: {
                    return new java.util.Date(Long.parseLong(o));
                }
                case DATE_SQL: {
                    return new Date(Long.parseLong(o));
                }
                case INSTANT: {
                    String[] parts = o.split("\\.");
                    return Instant.ofEpochSecond(Long.parseLong(parts[0]), Integer.parseInt(parts[1]));
                }
                case BIG_INTEGER: {
                    return new BigInteger(o);
                }
                case BIG_DECIMAL: {
                    return new BigDecimal(o);
                }
            }
            throw new IllegalArgumentException("Unsupported type convertation: " + (Object)((Object)type));
        }

        private IgniteBiTuple<String, Object> parseField(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonToken jsonToken = p.nextToken();
            if (JsonToken.END_ARRAY == jsonToken) {
                return null;
            }
            if (JsonToken.START_OBJECT == jsonToken) {
                String name = null;
                VisorDataType type = null;
                Object val = null;
                while (!p.isClosed() && jsonToken != JsonToken.END_OBJECT) {
                    jsonToken = p.nextToken();
                    if (JsonToken.FIELD_NAME == jsonToken) {
                        String fldName = p.getCurrentName();
                        jsonToken = p.nextToken();
                        switch (fldName) {
                            case "type": {
                                type = VisorDataType.valueOf(p.getValueAsString());
                                break;
                            }
                            case "name": {
                                name = p.getValueAsString();
                                break;
                            }
                            case "value": {
                                val = JsonToken.START_OBJECT == jsonToken ? this.parseObject(p, ctxt) : p.getValueAsString();
                            }
                        }
                        continue;
                    }
                    if (JsonToken.END_OBJECT == jsonToken) continue;
                    return (IgniteBiTuple)ctxt.handleUnexpectedToken(IgniteBiTuple.class, p);
                }
                return new IgniteBiTuple(name, type == VisorDataType.BINARY ? val : this.strToObject(type, String.valueOf(val)));
            }
            return (IgniteBiTuple)ctxt.handleUnexpectedToken(IgniteBiTuple.class, p);
        }

        private BinaryObject parseObject(JsonParser p, DeserializationContext ctxt) throws IOException {
            LinkedHashMap<Object, Object> flds = new LinkedHashMap<Object, Object>();
            String clsName = null;
            JsonToken jsonToken = null;
            while (!p.isClosed() && JsonToken.END_OBJECT != jsonToken) {
                jsonToken = p.nextToken();
                if (JsonToken.FIELD_NAME != jsonToken) continue;
                String fieldName = p.getCurrentName();
                jsonToken = p.nextToken();
                switch (fieldName) {
                    case "className": {
                        clsName = p.getValueAsString();
                        break;
                    }
                    case "fields": {
                        if (JsonToken.START_ARRAY != jsonToken) break;
                        IgniteBiTuple<String, Object> fld = null;
                        do {
                            if ((fld = this.parseField(p, ctxt)) == null) continue;
                            flds.put(fld.get1(), fld.get2());
                        } while (fld != null);
                    }
                }
            }
            if (clsName != null) {
                BinaryObjectBuilder b = Ignition.localIgnite().binary().builder(clsName);
                for (Map.Entry e : flds.entrySet()) {
                    b.setField((String)e.getKey(), e.getValue());
                }
                return b.build();
            }
            return (BinaryObject)ctxt.handleUnexpectedToken(BinaryObject.class, p);
        }

        public VisorCacheKeyObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken jsonToken = null;
            VisorDataType type = null;
            Object value = null;
            while (!p.isClosed() && JsonToken.END_OBJECT != jsonToken) {
                jsonToken = p.nextToken();
                if (JsonToken.FIELD_NAME != jsonToken) continue;
                String fieldName = p.getCurrentName();
                jsonToken = p.nextToken();
                switch (fieldName) {
                    case "type": {
                        type = VisorDataType.valueOf(p.getValueAsString());
                        break;
                    }
                    case "value": {
                        value = JsonToken.START_OBJECT == jsonToken ? this.parseObject(p, ctxt) : p.getValueAsString();
                    }
                }
            }
            return new VisorCacheKeyObject(type, VisorDataType.BINARY == type ? value : this.strToObject(type, String.valueOf(value)));
        }
    };
    private static final JsonSerializer<Throwable> THROWABLE_SERIALIZER = new JsonSerializer<Throwable>(){

        private void writeException(Throwable e, JsonGenerator gen) throws IOException {
            if (e instanceof VisorExceptionWrapper) {
                VisorExceptionWrapper wrapper = (VisorExceptionWrapper)e;
                gen.writeStringField("className", wrapper.getClassName());
            } else {
                gen.writeStringField("className", e.getClass().getName());
            }
            if (e.getMessage() != null) {
                gen.writeStringField("message", e.getMessage());
            }
            if (e instanceof SQLException) {
                SQLException sqlE = (SQLException)e;
                gen.writeNumberField("errorCode", sqlE.getErrorCode());
                gen.writeStringField("SQLState", sqlE.getSQLState());
            }
        }

        public void serialize(Throwable e, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            this.writeException(e, gen);
            gen.writeArrayFieldStart("stackTrace");
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                gen.writeString(stackTraceElement.toString());
            }
            gen.writeEndArray();
            if (e.getCause() != null) {
                gen.writeObjectField("cause", (Object)e.getCause());
            }
            if (!F.isEmpty((Object[])e.getSuppressed())) {
                gen.writeArrayFieldStart("suppressed");
                for (Serializable serializable : e.getSuppressed()) {
                    gen.writeObject((Object)serializable);
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<IgniteUuid> IGNITE_UUID_SERIALIZER = new JsonSerializer<IgniteUuid>(){

        public void serialize(IgniteUuid uid, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeString(uid.toString());
        }
    };
    private static final JsonSerializer<IgniteBiTuple> IGNITE_TUPLE_SERIALIZER = new JsonSerializer<IgniteBiTuple>(){

        public void serialize(IgniteBiTuple t, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("key", t.getKey());
            gen.writeObjectField("value", t.getValue());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<GridCacheSqlMetadata> IGNITE_SQL_METADATA_SERIALIZER = new JsonSerializer<GridCacheSqlMetadata>(){

        public void serialize(GridCacheSqlMetadata m, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("cacheName", m.cacheName());
            gen.writeObjectField("types", (Object)m.types());
            gen.writeObjectField("keyClasses", (Object)m.keyClasses());
            gen.writeObjectField("valClasses", (Object)m.valClasses());
            gen.writeObjectField("fields", (Object)m.fields());
            gen.writeObjectField("indexes", (Object)m.indexes());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<GridCacheSqlIndexMetadata> IGNITE_SQL_INDEX_METADATA_SERIALIZER = new JsonSerializer<GridCacheSqlIndexMetadata>(){

        public void serialize(GridCacheSqlIndexMetadata idx, JsonGenerator gen, SerializerProvider ser) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("name", idx.name());
            gen.writeObjectField("fields", (Object)idx.fields());
            gen.writeObjectField("descendings", (Object)idx.descendings());
            gen.writeBooleanField("unique", idx.unique());
            gen.writeEndObject();
        }
    };
    private static final JsonSerializer<BinaryObjectImpl> IGNITE_BINARY_OBJECT_SERIALIZER = new JsonSerializer<BinaryObjectImpl>(){

        public void serialize(BinaryObjectImpl bin, JsonGenerator gen, SerializerProvider ser) throws IOException {
            try {
                BinaryType meta = bin.rawType();
                if (meta != null && !F.isEmpty((Collection)meta.fieldNames())) {
                    gen.writeStartObject();
                    for (String name : meta.fieldNames()) {
                        BinaryObjectImpl ref;
                        Object val = bin.field(name);
                        if (val instanceof BinaryObjectImpl && (ref = (BinaryObjectImpl)val).hasCircularReferences()) {
                            ser.reportMappingProblem("Failed convert to JSON object for circular references", new Object[0]);
                        }
                        gen.writeObjectField(name, val);
                    }
                    gen.writeEndObject();
                } else {
                    Object obj = bin.deserialize();
                    gen.writeObject(obj);
                }
            }
            catch (BinaryObjectException ignore) {
                gen.writeNull();
            }
        }
    };

    public GridJettyObjectMapper() {
        super(null, (DefaultSerializerProvider)new CustomSerializerProvider(), null);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.setDateFormat(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        SimpleModule module = new SimpleModule().addSerializer(Throwable.class, THROWABLE_SERIALIZER).addSerializer(IgniteBiTuple.class, IGNITE_TUPLE_SERIALIZER).addSerializer(IgniteUuid.class, IGNITE_UUID_SERIALIZER).addSerializer(GridCacheSqlMetadata.class, IGNITE_SQL_METADATA_SERIALIZER).addSerializer(GridCacheSqlIndexMetadata.class, IGNITE_SQL_INDEX_METADATA_SERIALIZER).addSerializer(BinaryObjectImpl.class, IGNITE_BINARY_OBJECT_SERIALIZER).addDeserializer(VisorCacheKeyObject.class, VISOR_CACHE_KEY_OBJECT_DESERIALIZER);
        this.registerModule((Module)module);
    }

    private static class CustomSerializerProvider
    extends DefaultSerializerProvider {
        CustomSerializerProvider() {
        }

        CustomSerializerProvider(SerializerProvider src, SerializationConfig cfg, SerializerFactory f) {
            super(src, cfg, f);
        }

        public CustomSerializerProvider(CustomSerializerProvider src, CacheProvider cache) {
            super((DefaultSerializerProvider)src, cache);
        }

        public DefaultSerializerProvider createInstance(SerializationConfig cfg, SerializerFactory jsf) {
            return new CustomSerializerProvider((SerializerProvider)this, cfg, jsf);
        }

        public DefaultSerializerProvider withCaches(CacheProvider provider) {
            return new CustomSerializerProvider(this, provider);
        }

        public JsonSerializer<Object> findNullKeySerializer(JavaType serializationType, BeanProperty prop) {
            return NULL_KEY_SERIALIZER;
        }

        public JsonSerializer<Object> findNullValueSerializer(BeanProperty prop) {
            return NULL_VALUE_SERIALIZER;
        }
    }
}

