/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.zone;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;

@Controller(value="/management/v1/zones")
@Tag(name="dataNodes")
public interface DataNodesApi {
    @Get(value="{zoneName}/datanodes")
    @Operation(operationId="getDataNodesForZone", description="Returns current data nodes for zone.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data nodes are returned.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class), uniqueItems=true))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json", "application/problem+json"})
    public CompletableFuture<Set<String>> getDataNodesForZone(@PathVariable @Schema(description="Case-sensitive zone name to return data nodes for.") String var1);

    @Post(value="{zoneName}/datanodes/reset")
    @Operation(operationId="resetDataNodesForZone", description="Recalculates and resets data nodes for zone.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data nodes are recalculated and reset."), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> resetDataNodesForZone(@PathVariable @Schema(description="Case-sensitive zone name to recalculate data nodes for.") String var1);

    @Post(value="/datanodes/reset")
    @Operation(operationId="resetDataNodesForZones", description="Recalculates and resets data nodes for given zones.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data nodes are recalculated and reset."), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> resetDataNodesForZones(@Body @Schema(description="Names specifying zones to recalculate data nodes for. Case-sensitive, if empty then all zones' data nodes will be recalculated.") Optional<Set<String>> var1);
}

