/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.recovery.pitr;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.recovery.pitr.TablesRecoveryRequest;
import org.apache.ignite.internal.rest.api.recovery.pitr.TablesRecoveryResponse;
import org.apache.ignite.internal.rest.api.recovery.pitr.TablesRecoveryStateResponse;

@Controller(value="/management/v1/recovery/tables")
@Tag(name="recovery")
public interface PitrApi {
    @Post
    @Operation(operationId="recoverTables", description="Start a recovery process for tables.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Recovery state returned."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<TablesRecoveryResponse> recoverTables(@Body TablesRecoveryRequest var1);

    @Get(value="state/{operationId}")
    @Operation(operationId="getTablesRecoveryState", description="Get a state of recovery process for tables.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Recovery process started."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<TablesRecoveryStateResponse> getTablesRecoveryState(@PathVariable(value="operationId") @Parameter(required=true, description="Operation ID.") UUID var1);
}

