/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.deployment;

import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.deployment.DeploymentStatus;
import org.apache.ignite.internal.rest.api.deployment.InitialDeployMode;
import org.apache.ignite.internal.rest.api.deployment.UnitEntry;
import org.apache.ignite.internal.rest.api.deployment.UnitStatus;
import org.reactivestreams.Publisher;

@Controller(value="/management/v1/deployment/")
@Tag(name="deployment")
public interface DeploymentCodeApi {
    @Operation(operationId="deployUnit", summary="Deploy unit", description="Deploys provided unit to the cluster.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Unit deployed successfully.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="409", description="Unit with same identifier and version is already deployed.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"multipart/form-data"})
    @Post(value="units/{unitId}/{unitVersion}")
    public CompletableFuture<Boolean> deploy(@Schema(name="unitId", requiredMode=Schema.RequiredMode.REQUIRED, description="The ID of the deployment unit.") String var1, @Schema(name="unitVersion", requiredMode=Schema.RequiredMode.REQUIRED, description="The version of the deployment unit.") String var2, @Schema(name="unitContent", requiredMode=Schema.RequiredMode.REQUIRED, description="The code to deploy.") Publisher<CompletedFileUpload> var3, @QueryValue @Schema(name="deployMode", requiredMode=Schema.RequiredMode.REQUIRED, description="ALL or MAJORITY.") Optional<InitialDeployMode> var4, @QueryValue @Schema(name="initialNodes", requiredMode=Schema.RequiredMode.REQUIRED, description="List of node identifiers to deploy to.") Optional<List<String>> var5);

    @Operation(operationId="deployZipUnit", summary="Deploy unit with folders structure in zip.", description="Deploys provided unit in zip file to the cluster with folders structure.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Unit deployed successfully.", content={@Content(mediaType="application/json", schema=@Schema(type="boolean"))}), @ApiResponse(responseCode="409", description="Unit with same identifier and version is already deployed.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Deployment unit with unzip supports only single zip file.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"multipart/form-data"})
    @Post(value="units/zip/{unitId}/{unitVersion}")
    public CompletableFuture<Boolean> deployZip(@Schema(name="unitId", requiredMode=Schema.RequiredMode.REQUIRED, description="The ID of the deployment unit.") String var1, @Schema(name="unitVersion", requiredMode=Schema.RequiredMode.REQUIRED, description="The version of the deployment unit.") String var2, @Schema(name="unitContent", requiredMode=Schema.RequiredMode.REQUIRED, description="The zip file with unit content to deploy.") Publisher<CompletedFileUpload> var3, @QueryValue @Schema(name="deployMode", requiredMode=Schema.RequiredMode.REQUIRED, description="ALL or MAJORITY.") Optional<InitialDeployMode> var4, @QueryValue @Schema(name="initialNodes", requiredMode=Schema.RequiredMode.REQUIRED, description="List of node identifiers to deploy to.") Optional<List<String>> var5);

    @Operation(operationId="undeployUnit", summary="Undeploy unit", description="Undeploys the unit with provided unitId and unitVersion.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Unit undeployed successfully."), @ApiResponse(responseCode="404", description="Unit with provided identifier and version does not exist.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Delete(value="units/{unitId}/{unitVersion}")
    public CompletableFuture<Boolean> undeploy(@Schema(name="unitId", description="The ID of the deployment unit.", requiredMode=Schema.RequiredMode.REQUIRED) String var1, @Schema(name="unitVersion", description="The version of the deployment unit.", requiredMode=Schema.RequiredMode.REQUIRED) String var2);

    @Operation(operationId="listClusterStatuses", summary="Get cluster unit statuses", description="Cluster unit statuses.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All statuses returned successfully.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UnitStatus.class)))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="cluster/units")
    public CompletableFuture<Collection<UnitStatus>> clusterStatuses(@Schema(name="statuses", description="Deployment status filter.") Optional<List<DeploymentStatus>> var1);

    @Operation(operationId="listClusterStatusesByUnit", summary="Get specific cluster unit statuses", description="Cluster unit statuses by unit.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All statuses returned successfully.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UnitStatus.class)))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="cluster/units/{unitId}")
    public CompletableFuture<Collection<UnitStatus>> clusterStatuses(@Schema(name="unitId", description="The ID of the deployment unit.") String var1, @Schema(name="version", description="Unit version filter.") Optional<String> var2, @Schema(name="statuses", description="Deployment status filter.") Optional<List<DeploymentStatus>> var3);

    @Operation(operationId="listNodeStatuses", summary="Get node unit statuses", description="Returns a list of unit statuses per node.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All statuses were returned successfully.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UnitStatus.class)))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="node/units")
    public CompletableFuture<Collection<UnitStatus>> nodeStatuses(@Schema(name="statuses", description="Deployment status filter.") Optional<List<DeploymentStatus>> var1);

    @Operation(operationId="listNodeStatusesByUnit", summary="Get specific node unit statuses", description="Returns a list of node unit statuses by unit.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All statuses returned successfully.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UnitStatus.class)))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="node/units/{unitId}")
    public CompletableFuture<Collection<UnitStatus>> nodeStatuses(@Schema(name="unitId", description="The ID of the deployment unit.") String var1, @Schema(name="version", description="Unit version filter.") Optional<String> var2, @Schema(name="statuses", description="Deployment status filter.") Optional<List<DeploymentStatus>> var3);

    @Operation(operationId="unitContent", summary="Get unit contents.", description="Returns a folder representation with unit content.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Unit content returned successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UnitEntry.UnitFolder.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="node/units/structure/{unitId}/{unitVersion}")
    public CompletableFuture<UnitEntry.UnitFolder> unitStructure(@Schema(name="unitId", description="The ID of the deployment unit.") String var1, @Schema(name="unitVersion", description="The version of the deployment unit.") String var2);
}

