/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.UUID;

@Schema(description="Unique tag that identifies the cluster.")
public class ClusterTag {
    @Schema(description="Unique cluster UUID. Generated automatically.")
    private final UUID clusterId;
    @Schema(description="Unique cluster name.")
    private final String clusterName;

    @JsonCreator
    public ClusterTag(@JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="clusterId") UUID clusterId) {
        this.clusterName = clusterName;
        this.clusterId = clusterId;
    }

    @JsonGetter(value="clusterId")
    public UUID clusterId() {
        return this.clusterId;
    }

    @JsonGetter(value="clusterName")
    public String clusterName() {
        return this.clusterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterTag that = (ClusterTag)o;
        return this.clusterId.equals(that.clusterId) && this.clusterName.equals(that.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.clusterName);
    }

    public String toString() {
        return "ClusterTag{clusterId=" + this.clusterId + ", clusterName='" + this.clusterName + "'}";
    }
}

