/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import java.util.Set;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;
import org.apache.ignite.lang.ErrorGroups;

@Singleton
@Requires(classes={IgniteInternalException.class, ExceptionHandler.class})
public class IgniteInternalExceptionHandler
implements ExceptionHandler<IgniteInternalException, HttpResponse<? extends Problem>> {
    private static final Set<Integer> BAD_REQUEST_CODES = Set.of(Integer.valueOf(ErrorGroups.DistributionZones.ZONE_NOT_FOUND_ERR), Integer.valueOf(ErrorGroups.DisasterRecovery.ILLEGAL_PARTITION_ID_ERR), Integer.valueOf(ErrorGroups.DisasterRecovery.NODES_NOT_FOUND_ERR), Integer.valueOf(ErrorGroups.DisasterRecovery.ILLEGAL_NODES_SET_ERR));

    public HttpResponse<? extends Problem> handle(HttpRequest request, IgniteInternalException exception) {
        if (BAD_REQUEST_CODES.contains(exception.code())) {
            return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).detail(exception.getMessage()).traceId(exception.traceId()).code(exception.codeAsString()));
        }
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.INTERNAL_SERVER_ERROR).traceId(exception.traceId()).code(exception.codeAsString()).detail(exception.getMessage()));
    }
}

