/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.recovery;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.recovery.GlobalZonePartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalZonePartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.ResetZonePartitionsRequest;
import org.apache.ignite.internal.rest.api.recovery.RestartZonePartitionsRequest;

@Controller(value="/management/v1/recovery")
@Tag(name="recovery")
public interface DisasterRecoveryApi {
    @Post(value="zone/partitions/reset")
    @Operation(operationId="resetZonePartitions", description="Updates assignments of zone's partitions in a forced manner, allowing for the recovery of raft groups with lost majorities.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Partition states reset."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> resetZonePartitions(@Body ResetZonePartitionsRequest var1);

    @Post(value="zone/partitions/restart")
    @Operation(operationId="restartZonePartitions", description="Restarts replica service and raft group of passed zone partitions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Zone partitions restarted."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> restartZonePartitions(@Body RestartZonePartitionsRequest var1);

    @Post(value="zone/partitions/restartWithCleanup")
    @Operation(operationId="restartZonePartitionsWithCleanup", description="Restarts replica service and raft group of passed zone partitions with cleaning up of the storage.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Zone partitions restarted."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    public CompletableFuture<Void> restartZonePartitionsWithCleanup(@Body RestartZonePartitionsRequest var1);

    @Get(value="zone/state/local")
    @Operation(operationId="getZoneLocalPartitionStates", description="Returns local zone partition states.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Zone partition states returned."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json"})
    public CompletableFuture<LocalZonePartitionStatesResponse> getZoneLocalPartitionStates(@QueryValue @Schema(description="Names specifying zones to get partition states from. Case-sensitive, all zones if empty.") Optional<Set<String>> var1, @QueryValue @Schema(description="Names specifying nodes to get partition states from. Case-sensitive, all nodes if empty.") Optional<Set<String>> var2, @QueryValue @Schema(description="IDs of partitions to get states. All partitions if empty.") Optional<Set<Integer>> var3);

    @Get(value="zone/state/global")
    @Operation(operationId="getZoneGlobalPartitionStates", description="Returns global zone partition states.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Zone partition states returned."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json"})
    public CompletableFuture<GlobalZonePartitionStatesResponse> getZoneGlobalPartitionStates(@QueryValue @Schema(description="Names specifying zones to get partition states from. Case-sensitive, all zones if empty.") Optional<Set<String>> var1, @QueryValue @Schema(description="IDs of partitions to get states of. All partitions if empty.") Optional<Set<Integer>> var2);
}

