/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.rbac.privileges;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.rbac.assignmens.PrivilegeAssignment;
import org.apache.ignite.internal.rest.api.rbac.privileges.Privilege;
import org.apache.ignite.internal.rest.api.rbac.privileges.RolePrivileges;

@Controller(value="/management/v1/rbac/pg")
@Secured(value={"isAuthenticated()"})
@Tag(name="privilegesGrants")
public interface PrivilegesApi {
    @Operation(operationId="getPrivileges", summary="Get granted privileges", description="Returns the list of all granted privileges to role.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all granted privileges to role.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Privilege.class)))}), @ApiResponse(responseCode="404", description="No privileges endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="{roleName}")
    public CompletableFuture<Iterable<Privilege>> privileges(@Parameter(required=true, description="Role name.") String var1);

    @Operation(operationId="grantPrivileges", summary="Grant privileges", description="Grants privileges to roles.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Privileges granted to roles."), @ApiResponse(responseCode="404", description="No grant privilege endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Post
    public CompletableFuture<Void> grant(@Body @RequestBody(description="Role assignment.") PrivilegeAssignment var1);

    @Operation(operationId="revokePrivileges", summary="Revoke privileges", description="Revokes privileges from roles.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Privileges revoked from roles."), @ApiResponse(responseCode="404", description="No revoke endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Delete
    public CompletableFuture<Void> revoke(@Body @RequestBody(description="Role assignment.") PrivilegeAssignment var1);

    @Operation(operationId="getRolesWithPrivileges", summary="Get all roles with privilege", description="Returns the list of all roles with granted privileges.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all roles with granted privileges.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RolePrivileges.class)))}), @ApiResponse(responseCode="404", description="No privileges endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="roles")
    public CompletableFuture<Iterable<RolePrivileges>> rolesWithPrivileges();
}

