/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.jwt;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.jwt.LoginBody;

@Controller(value="/management/v1/authentication")
@Tag(name="authentication")
public interface AuthenticationApi {
    @Operation(operationId="login", summary="Get JWT", description="Get JWT for the user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="JWT returned.", content={@Content(mediaType="application/jwt", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Invalid credentials.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Post(value="/login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    @Secured(value={"isAnonymous()"})
    public CompletableFuture<String> login(@Body LoginBody var1);

    @Operation(operationId="revokeToken", summary="Revoke JWT", description="Revoke a specific JWT.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="JWT was revoked."), @ApiResponse(responseCode="400", description="Token is invalid.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Delete(value="/jwt/{token}")
    public CompletableFuture<Void> revokeToken(@Schema(name="token", requiredMode=Schema.RequiredMode.REQUIRED, description="JWT to revoke.") String var1);

    @Operation(operationId="revokeTokensByUsername", summary="Revoke all JWTs", description="Revoke all issued JWTs.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All issued JWT were revoked."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Delete(value="/jwt")
    public CompletableFuture<Void> revokeAllTokens(@QueryValue(value="username") @Schema(name="username", requiredMode=Schema.RequiredMode.REQUIRED, description="Username to revoke all issued JWTs from.") String var1);
}

