/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Requires(classes={ExceptionHandler.class})
public class UnsupportedOperationExceptionHandler
implements ExceptionHandler<UnsupportedOperationException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, UnsupportedOperationException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.NOT_IMPLEMENTED).detail(exception.getMessage()));
    }
}

