/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.rbac.assignmens;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.rbac.assignmens.RoleAssignment;
import org.apache.ignite.internal.rest.api.rbac.role.RoleDto;
import org.apache.ignite.internal.rest.api.rbac.role.RoleViewDto;
import org.apache.ignite.internal.rest.api.rbac.user.UserDto;
import org.apache.ignite.internal.rest.api.rbac.user.UserRoles;

@Controller(value="/management/v1/rbac/ra")
@Secured(value={"isAuthenticated()"})
@Tag(name="roleAssignments")
public interface RoleAssignmentsApi {
    @Operation(operationId="getRolesByUser", summary="Get user roles", description="Returns the list of all roles assigned to user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all roles assigned to user.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RoleDto.class)))}), @ApiResponse(responseCode="404", description="No roles endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="roles/{username}")
    public CompletableFuture<Iterable<RoleDto>> roles(@PathVariable(value="username") @Parameter(required=true, description="Username.") String var1);

    @Operation(operationId="getUsersByRole", summary="Get users who have role", description="Returns the list of all users assigned to role.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all users assigned to role.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UserDto.class)))}), @ApiResponse(responseCode="404", description="No users endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="users/{roleName}")
    public CompletableFuture<Iterable<UserDto>> users(@PathVariable(value="roleName") @Parameter(required=true, description="Role name.") String var1);

    @Operation(operationId="getUsersWithRoles", summary="Get users who have all specified roles", description="Returns the list of all users with assigned roles.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all users with assigned roles.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UserRoles.class)))}), @ApiResponse(responseCode="404", description="No users endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="users")
    public CompletableFuture<Iterable<UserRoles>> usersWithRoles();

    @Operation(operationId="getRoleViews", summary="Get roles with users and privileges", description="Returns the list of all roles with associated users and assigned privileges.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all roles with associated users and assigned privileges.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RoleViewDto.class)))}), @ApiResponse(responseCode="404", description="No role endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="roles")
    public CompletableFuture<Iterable<RoleViewDto>> rolesViews();

    @Operation(operationId="assignRoles", summary="Assign roles to users", description="Assigns roles to users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Roles assigned to users."), @ApiResponse(responseCode="404", description="No assign endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Post
    public CompletableFuture<Void> assign(@Body @RequestBody(description="Role assignment.") RoleAssignment var1);

    @Operation(operationId="revokeRoles", summary="Revoke roles from users", description="Revokes roles from users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Roles revoked from users."), @ApiResponse(responseCode="404", description="No revoke endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Delete
    public CompletableFuture<Void> revoke(@Body @RequestBody(description="Role assignment.") RoleAssignment var1);
}

