/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.license;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.rest.api.license.LicenseInfo;
import org.apache.ignite.internal.rest.api.license.LicenseLimits;
import org.apache.ignite.internal.rest.api.license.Signatures;

@Schema(description="License information")
public class License {
    @Schema(description="Edition")
    private String edition;
    @Schema(description="List of enabled features")
    private List<String> features;
    @Schema(description="Unique identifier of the license")
    private String id;
    @Schema(description="Company and contact information")
    private LicenseInfo infos;
    @Schema(description="License limitations")
    private LicenseLimits limits;
    @Schema(description="Release type")
    private String releaseType;
    @Schema(description="Signatures")
    private Signatures signatures;

    public License() {
    }

    @JsonCreator
    public License(@JsonProperty(value="edition") String edition, @JsonProperty(value="features") List<String> features, @JsonProperty(value="id") String id, @JsonProperty(value="infos") LicenseInfo infos, @JsonProperty(value="limits") LicenseLimits limits, @JsonProperty(value="releaseType") String releaseType, @JsonProperty(value="signatures") Signatures signatures) {
        this.edition = edition;
        this.features = features;
        this.id = id;
        this.infos = infos;
        this.limits = limits;
        this.releaseType = releaseType;
        this.signatures = signatures;
    }

    @JsonProperty(value="edition")
    public String getEdition() {
        return this.edition;
    }

    @JsonProperty(value="features")
    public List<String> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="signatures")
    public Signatures getSignatures() {
        return this.signatures;
    }

    @JsonSetter(value="edition")
    public void setEdition(String edition) {
        this.edition = edition;
    }

    @JsonSetter(value="signatures")
    public void setSignatures(Signatures signatures) {
        this.signatures = signatures;
    }

    @JsonSetter(value="releaseType")
    public void setReleaseType(String releaseType) {
        this.releaseType = releaseType;
    }

    @JsonProperty(value="releaseType")
    public String getReleaseType() {
        return this.releaseType;
    }

    @JsonSetter(value="features")
    public void setFeatures(List<String> features) {
        this.features = features;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="infos")
    public LicenseInfo getInfos() {
        return this.infos;
    }

    @JsonSetter(value="infos")
    public void setInfos(LicenseInfo infos) {
        this.infos = infos;
    }

    @JsonProperty(value="limits")
    public LicenseLimits getLimits() {
        return this.limits;
    }

    @JsonSetter(value="limits")
    public void setLimits(LicenseLimits limits) {
        this.limits = limits;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License that = (License)o;
        return Objects.equals(this.edition, that.edition) && Objects.equals(this.features, that.features) && Objects.equals(this.id, that.id) && Objects.equals(this.infos, that.infos) && Objects.equals(this.limits, that.limits) && Objects.equals(this.signatures, that.signatures);
    }

    public int hashCode() {
        return Objects.hash(this.edition, this.features, this.id, this.infos, this.limits, this.signatures);
    }
}

