/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.rest.api.cdc.Source;
import org.apache.ignite.internal.rest.api.cdc.Violations;
import org.apache.ignite.internal.tostring.S;

@Schema(description="Source status", name="SourceStatus")
public class SourceStatus {
    @Schema(description="Source")
    private Source source;
    @Schema(description="Checks")
    private List<Violations> violations;

    @JsonCreator
    public SourceStatus(@JsonProperty(value="source") Source source, List<Violations> violations) {
        this.source = source;
        this.violations = violations;
    }

    @JsonGetter
    public Source source() {
        return this.source;
    }

    @JsonGetter
    public List<Violations> violations() {
        return this.violations;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceStatus that = (SourceStatus)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.violations, that.violations);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.violations);
    }

    public String toString() {
        return S.toString(SourceStatus.class, (Object)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Source source;
        private List<Violations> violations;

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder violations(List<Violations> violations) {
            this.violations = violations;
            return this;
        }

        public SourceStatus build() {
            return new SourceStatus(this.source, this.violations);
        }
    }
}

