/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.rbac.user;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Put;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.rbac.user.CreateUserRequest;
import org.apache.ignite.internal.rest.api.rbac.user.UserDto;

@Controller(value="/management/v1/rbac/users")
@Secured(value={"isAuthenticated()"})
@Tag(name="userManagement")
public interface UserManagementApi {
    @Operation(operationId="getUsers", summary="Get the list of users", description="Returns the list of all users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all users.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UserDto.class)))}), @ApiResponse(responseCode="404", description="No users endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get
    public CompletableFuture<Iterable<UserDto>> users();

    @Operation(operationId="getUser", summary="Get user by username", description="Returns a user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a user.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserDto.class))}), @ApiResponse(responseCode="404", description="No such user or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="{username}")
    public CompletableFuture<UserDto> user(@PathVariable(value="username") @Parameter(required=true, description="Username.") String var1);

    @Operation(operationId="createUser", summary="Create user", description="Creates a user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect user.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The user already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Post
    public CompletableFuture<Void> create(@Body @RequestBody(description="User body.") CreateUserRequest var1);

    @Operation(operationId="deleteUser", summary="Delete user by username", description="Deletes a user by username.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User is deleted."), @ApiResponse(responseCode="404", description="No such user or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Delete(value="{username}")
    public CompletableFuture<Void> delete(@PathVariable(value="username") @Parameter(required=true, description="Username.") String var1);

    @Operation(operationId="updateUser", summary="Update user", description="Updates a user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect user.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The user is already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Put(value="{username}")
    public CompletableFuture<Void> update(@PathVariable(value="username") @Parameter(required=true, description="Username.") String var1, @Body @RequestBody(description="User body.") CreateUserRequest var2);
}

