/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.compute;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Put;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.compute.JobState;
import org.apache.ignite.internal.rest.api.compute.UpdateJobPriorityBody;

@Controller(value="/management/v1/compute/")
@Tag(name="compute")
public interface ComputeApi {
    @Operation(summary="Retrieve all job states", description="Fetches the current states of all compute jobs.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved job states.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=JobState.class)))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="jobs")
    public CompletableFuture<Collection<JobState>> jobStates();

    @Operation(summary="Retrieve job state", description="Fetches the current state of a specific compute job identified by jobId.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved the job state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=JobState.class))}), @ApiResponse(responseCode="404", description="Compute job not found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="jobs/{jobId}")
    public CompletableFuture<JobState> jobState(@Schema(name="jobId", description="The unique identifier of the compute job.", requiredMode=Schema.RequiredMode.REQUIRED) UUID var1);

    @Operation(summary="Update job priority", description="Updates the priority of a specific compute job identified by jobId.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully updated job priority.", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Compute job not found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Compute job is in an illegal state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Put(value="jobs/{jobId}/priority")
    public CompletableFuture<Void> updatePriority(@Schema(name="jobId", description="The unique identifier of the compute job.", requiredMode=Schema.RequiredMode.REQUIRED) UUID var1, @Body UpdateJobPriorityBody var2);

    @Operation(summary="Cancel job", description="Cancels a specific compute job identified by jobId.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully cancelled the job.", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Compute job not found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Compute job is in an illegal state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Delete(value="jobs/{jobId}")
    public CompletableFuture<Void> cancelJob(@Schema(name="jobId", description="The unique identifier of the compute job.", requiredMode=Schema.RequiredMode.REQUIRED) UUID var1);
}

