/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.rest.api.cdc.CdcReplicationStatus;
import org.apache.ignite.internal.rest.api.cdc.ReplicationMode;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class Replication {
    private String name;
    private String sinkName;
    private String sourceName;
    private ReplicationMode mode;
    private List<String> executionNodes;
    @Nullable
    private CdcReplicationStatus status;
    @Nullable
    private String errorContext;

    @JsonCreator
    public Replication(@JsonProperty(value="name") String name, @JsonProperty(value="sinkName") String sinkName, @JsonProperty(value="sourceName") String sourceName, @JsonProperty(value="mode") ReplicationMode mode, @JsonProperty(value="executionNodes") List<String> executionNodes, @JsonProperty(value="status") @Nullable CdcReplicationStatus status, @JsonProperty(value="errorContext") @Nullable String errorContext) {
        this.name = name;
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.mode = mode;
        this.executionNodes = executionNodes;
        this.status = status;
        this.errorContext = errorContext;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonGetter(value="sinkName")
    public String sinkName() {
        return this.sinkName;
    }

    @JsonGetter(value="sourceName")
    public String sourceName() {
        return this.sourceName;
    }

    @JsonGetter(value="mode")
    public ReplicationMode mode() {
        return this.mode;
    }

    @JsonGetter(value="executionNodes")
    public List<String> executionNodes() {
        return this.executionNodes;
    }

    @JsonGetter(value="status")
    @Nullable
    public CdcReplicationStatus status() {
        return this.status;
    }

    @JsonGetter(value="errorContext")
    @Nullable
    public String errorContext() {
        return this.errorContext;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replication that = (Replication)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.sinkName, that.sinkName) && Objects.equals(this.sourceName, that.sourceName) && this.mode == that.mode && Objects.equals(this.executionNodes, that.executionNodes) && this.status == that.status && Objects.equals(this.errorContext, that.errorContext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sinkName, this.sourceName, this.mode, this.executionNodes, this.status, this.errorContext});
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public static ReplicationBuilder builder() {
        return new ReplicationBuilder();
    }

    public static ReplicationBuilder builderFrom(Replication replication) {
        return new ReplicationBuilder().name(replication.name).sinkName(replication.sinkName).sourceName(replication.sourceName).mode(replication.mode).executionNodes(replication.executionNodes).status(replication.status).errorContext(replication.errorContext);
    }

    public static class ReplicationBuilder {
        private String name;
        private String sinkName;
        private String sourceName;
        private ReplicationMode mode;
        private List<String> executionNodes;
        @Nullable
        private CdcReplicationStatus status;
        @Nullable
        private String errorContext;

        public ReplicationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReplicationBuilder sinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        public ReplicationBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public ReplicationBuilder mode(ReplicationMode mode) {
            this.mode = mode;
            return this;
        }

        public ReplicationBuilder executionNodes(List<String> executionNodes) {
            this.executionNodes = executionNodes;
            return this;
        }

        public ReplicationBuilder status(@Nullable CdcReplicationStatus status) {
            this.status = status;
            return this;
        }

        public ReplicationBuilder errorContext(@Nullable String errorContext) {
            this.errorContext = errorContext;
            return this;
        }

        public Replication build() {
            return new Replication(this.name, this.sinkName, this.sourceName, this.mode, this.executionNodes, this.status, this.errorContext);
        }
    }
}

