/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cdc;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Put;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.cdc.Replication;
import org.apache.ignite.internal.rest.api.cdc.Sink;
import org.apache.ignite.internal.rest.api.cdc.SinkStatus;
import org.apache.ignite.internal.rest.api.cdc.Source;
import org.apache.ignite.internal.rest.api.cdc.SourceStatus;

@Controller(value="/management/v1/cdc")
@Secured(value={"isAuthenticated()"})
@Tag(name="cdcManagement")
public interface CdcApi {
    @Operation(operationId="getSources", summary="Get the list of CDC sources", description="Returns the list of all CDC sources.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all sources.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Source.class)))}), @ApiResponse(responseCode="404", description="No sources endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="sources")
    public CompletableFuture<Collection<Source>> sources();

    @Operation(operationId="getSource", summary="Get CDC source by name", description="Returns a CDC source.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a source.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Source.class))}), @ApiResponse(responseCode="404", description="No such source or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="sources/{name}")
    public CompletableFuture<Source> getSource(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1);

    @Operation(operationId="getSourceStatus", summary="Get CDC source status by name", description="Returns a CDC source status.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a source status.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SourceStatus.class))}), @ApiResponse(responseCode="404", description="No such source or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="sources/{name}/status")
    public CompletableFuture<SourceStatus> getSourceStatus(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1);

    @Operation(operationId="createSource", summary="Create CDC source. CDC source is identified by unique name. CDC source has a type, parameters and a list of tables that should be replicated.", description="Creates a CDC source.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Source is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect source.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The source already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Post(value="sources")
    public CompletableFuture<Void> createSource(@Body @RequestBody(description="Source body.") Source var1);

    @Operation(operationId="deleteSource", summary="Delete CDC source by name", description="Deletes a CDC source by name.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Source is deleted."), @ApiResponse(responseCode="404", description="No such source or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Delete(value="sources/{name}")
    public CompletableFuture<Void> deleteSource(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1);

    @Operation(operationId="updateSource", summary="Update CDC source", description="Updates a CDC source.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="CDC source is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect source.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The source is already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Put(value="sources/{name}")
    public CompletableFuture<Void> updateSource(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1, @Body @RequestBody(description="Source body.") Source var2);

    @Operation(operationId="getSinks", summary="Get the list of CDC sinks", description="Returns the list of all CDC sinks.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all sinks.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Sink.class)))}), @ApiResponse(responseCode="404", description="No sources endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="sinks")
    public CompletableFuture<Collection<Sink>> sinks();

    @Operation(operationId="getSink", summary="Get CDC sink by name", description="Returns a CDC sink.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a sink.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Sink.class))}), @ApiResponse(responseCode="404", description="No such sink or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="sinks/{name}")
    public CompletableFuture<Sink> getSink(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1);

    @Operation(operationId="getSinkStatus", summary="Get CDC sink status by name", description="Returns a CDC sink status.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a sink status.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SinkStatus.class))}), @ApiResponse(responseCode="404", description="No such sink or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="sinks/{name}/status")
    public CompletableFuture<SinkStatus> getSinkStatus(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1);

    @Operation(operationId="createSink", summary="Create CDC sink. CDC sink is identified by unique name. CDC sink has a type, parameters and a list of tables that should be replicated.", description="Creates a CDC sink.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Sink is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect sink.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The sink already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Post(value="sinks")
    public CompletableFuture<Void> createSink(@Body @RequestBody(description="Sink body.") Sink var1);

    @Operation(operationId="deleteSink", summary="Delete CDC sink by name", description="Deletes a CDC sink by name.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Sink is deleted."), @ApiResponse(responseCode="404", description="No such sink or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Delete(value="sinks/{name}")
    public CompletableFuture<Void> deleteSink(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1);

    @Operation(operationId="updateSink", summary="Update CDC sink", description="Updates a CDC sink.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="CDC sink is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect sink.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The sink is already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Put(value="sinks/{name}")
    public CompletableFuture<Void> updateSink(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1, @Body @RequestBody(description="Sink body.") Sink var2);

    @Operation(operationId="getCdcReplications", summary="Get the list of CDC replications", description="Returns the list of all CDC replications.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all replications.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Replication.class)))}), @ApiResponse(responseCode="404", description="No replications endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="replications")
    public CompletableFuture<Collection<Replication>> replications();

    @Operation(operationId="getCdcReplication", summary="Get CDC replication by name", description="Returns a CDC replication.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a replication.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Replication.class))}), @ApiResponse(responseCode="404", description="No such replication or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="replications/{name}")
    public CompletableFuture<Replication> getCdcReplication(@PathVariable(value="name") @Parameter(required=true, description="Name.") String var1);

    @Operation(operationId="createCdcReplication", summary="Create CDC replication. CDC replication is identified by unique name. CDC replication has a type, parameters and a list of tables that should be replicated.", description="Creates a CDC replication.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect replication.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The replication already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Post(value="replications")
    public CompletableFuture<Void> createCdcReplication(@Body @RequestBody(description="Replication body.") Replication var1);

    @Operation(operationId="deleteCdcReplication", summary="Delete CDC replication by name", description="Deletes a CDC replication by name.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication is deleted."), @ApiResponse(responseCode="404", description="No such replication or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Delete(value="replications/{name}")
    public CompletableFuture<Void> deleteCdcReplication(@PathVariable(value="name") @Parameter(required=true, description="Replication name.") String var1);

    @Operation(operationId="startCdcReplication", summary="Start CDC replication by name", description="Start a CDC replication by name.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication is started."), @ApiResponse(responseCode="404", description="No such replication or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Post(value="replications/{name}")
    public CompletableFuture<Void> startCdcReplication(@PathVariable(value="name") @Parameter(required=true, description="Replication name.") String var1);

    @Operation(operationId="stopCdcReplication", summary="Stop CDC replication by name", description="Stop a CDC replication by name.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Replication is started."), @ApiResponse(responseCode="404", description="No such replication or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Post(value="replications/{name}/stop")
    public CompletableFuture<Void> stopCdcReplication(@PathVariable(value="name") @Parameter(required=true, description="Replication name.") String var1);
}

