/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.upgrade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.Set;

@Schema(description="Cluster Upgrade State.")
public class UpgradeStateResponse {
    @Schema(description="Current cluster version.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String currentVersion;
    @Schema(description="Next cluster version.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String nextVersion;
    @Schema(description="Current cluster version nodes.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final Set<String> currentVersionNodes;
    @Schema(description="Next cluster version nodes.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final Set<String> nextVersionNodes;

    @JsonCreator
    public UpgradeStateResponse(@JsonProperty(value="currentVersion") String currentVersion, @JsonProperty(value="nextVersion") String nextVersion, @JsonProperty(value="currentVersionNodes") Set<String> currentVersionNodes, @JsonProperty(value="nextVersionNodes") Set<String> nextVersionNodes) {
        this.currentVersion = currentVersion;
        this.nextVersion = nextVersion;
        this.currentVersionNodes = currentVersionNodes;
        this.nextVersionNodes = nextVersionNodes;
    }

    @JsonProperty(value="currentVersion")
    public String currentVersion() {
        return this.currentVersion;
    }

    @JsonProperty(value="nextVersion")
    public String nextVersion() {
        return this.nextVersion;
    }

    @JsonProperty(value="currentVersionNodes")
    public Set<String> currentVersionNodes() {
        return this.currentVersionNodes;
    }

    @JsonProperty(value="nextVersionNodes")
    public Set<String> nextVersionNodes() {
        return this.nextVersionNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeStateResponse that = (UpgradeStateResponse)o;
        return Objects.equals(this.currentVersion, that.currentVersion) && Objects.equals(this.nextVersion, that.nextVersion) && Objects.equals(this.currentVersionNodes, that.currentVersionNodes) && Objects.equals(this.nextVersionNodes, that.nextVersionNodes);
    }

    public int hashCode() {
        return Objects.hash(this.currentVersion, this.nextVersion, this.currentVersionNodes, this.nextVersionNodes);
    }
}

