/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.snapshot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

@Schema(description="Snapshot restoration configuration.")
public class RestoreCommand {
    @Schema(description="ID of the snapshot to restore")
    private final UUID snapshotId;
    @Schema(description="Set of fully-qualified table names to restore.")
    private final Set<String> tableNames;
    @Schema(description="The name of the snapshot path to restore the snapshot from; null to use the default path.")
    private final String source;
    @Schema(description="The decription provider name.")
    private final String decryptionProvider;

    @JsonCreator
    public RestoreCommand(@JsonProperty(value="snapshotId") UUID snapshotId, @JsonProperty(value="tableNames") @Nullable Collection<String> tableNames, @JsonProperty(value="source") @Nullable String source, @JsonProperty(value="decryptionProvider") @Nullable String decryptionProvider) {
        Set<Object> set = this.tableNames = tableNames == null ? Collections.emptySet() : Set.copyOf(tableNames);
        if (this.tableNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Table names must not contain blank strings: " + tableNames);
        }
        this.snapshotId = snapshotId;
        this.source = source;
        this.decryptionProvider = decryptionProvider;
    }

    @JsonGetter(value="snapshotId")
    public UUID snapshotId() {
        return this.snapshotId;
    }

    @JsonGetter(value="tableNames")
    public Set<String> tableNames() {
        return this.tableNames;
    }

    @JsonGetter(value="source")
    @Nullable
    public String source() {
        return this.source;
    }

    @JsonGetter(value="decryptionProvider")
    @Nullable
    public String decryptionProvider() {
        return this.decryptionProvider;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

