/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.rbac.role;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.security.annotation.Secured;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.rbac.role.RoleDto;

@Controller(value="/management/v1/rbac/roles")
@Secured(value={"isAuthenticated()"})
@Tag(name="roleManagement")
public interface RoleManagementApi {
    @Operation(operationId="getRoles", summary="Get the list of roles", description="Returns the list of all roles.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the list of all roles.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RoleDto.class)))}), @ApiResponse(responseCode="404", description="No roles endpoint enabled. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get
    public CompletableFuture<Iterable<RoleDto>> roles();

    @Operation(operationId="getRole", summary="Get role by name", description="Returns a role.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a role.", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleDto.class))}), @ApiResponse(responseCode="404", description="No such role or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="{roleName}")
    public CompletableFuture<RoleDto> role(@PathVariable(value="roleName") @Parameter(required=true, description="Role name.") String var1);

    @Operation(operationId="createRole", summary="Create role", description="Create role.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Role is created."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect user.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Endpoint not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="The role already exists", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Post
    public CompletableFuture<Void> create(@Body @RequestBody(description="Role body.") RoleDto var1);

    @Operation(operationId="deleteRole", summary="Delete role by name", description="Delete a role.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Role is deleted."), @ApiResponse(responseCode="404", description="No such role or the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Missing license error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Delete(value="{roleName}")
    public CompletableFuture<Void> delete(@PathVariable(value="roleName") @Parameter(required=true, description="Role name.") String var1, @QueryValue(defaultValue="false") @Schema(name="revoke", requiredMode=Schema.RequiredMode.NOT_REQUIRED, description="Revoke role from all users.", defaultValue="false") boolean var2);
}

