/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

@Schema(description="Cluster initialization configuration.")
public class InitCommand {
    @Schema(description="A list of RAFT metastorage nodes.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final Collection<String> metaStorageNodes;
    @Schema(description="A list of RAFT cluster management nodes.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final Collection<String> cmgNodes;
    @Schema(description="The name of the cluster.")
    private final String clusterName;
    @Schema(description="Cluster configuration in HOCON format.")
    private final String clusterConfiguration;
    @Schema(description="Cluster license.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String license;

    @JsonCreator
    public InitCommand(@JsonProperty(value="metaStorageNodes") Collection<String> metaStorageNodes, @JsonProperty(value="cmgNodes") @Nullable Collection<String> cmgNodes, @JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="clusterConfiguration") String clusterConfiguration, @JsonProperty(value="license") String license) {
        if (!CollectionUtils.nullOrEmpty(metaStorageNodes) && metaStorageNodes.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Meta Storage node names must not contain blank strings: " + metaStorageNodes);
        }
        if (!CollectionUtils.nullOrEmpty(cmgNodes) && cmgNodes.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("CMG node names must not contain blank strings: " + cmgNodes);
        }
        if (clusterName.isBlank()) {
            throw new IllegalArgumentException("Cluster name must not be empty.");
        }
        if (license == null) {
            throw new IllegalArgumentException("License must not be empty.");
        }
        this.metaStorageNodes = metaStorageNodes == null ? List.of() : List.copyOf(metaStorageNodes);
        this.cmgNodes = cmgNodes == null ? List.of() : List.copyOf(cmgNodes);
        this.clusterName = clusterName;
        this.clusterConfiguration = clusterConfiguration;
        this.license = license;
    }

    @JsonGetter(value="metaStorageNodes")
    public Collection<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    @JsonGetter(value="cmgNodes")
    public Collection<String> cmgNodes() {
        return this.cmgNodes;
    }

    @JsonGetter(value="clusterName")
    public String clusterName() {
        return this.clusterName;
    }

    @JsonGetter(value="clusterConfiguration")
    public String clusterConfiguration() {
        return this.clusterConfiguration;
    }

    @JsonGetter(value="license")
    public String license() {
        return this.license;
    }

    public String toString() {
        return "InitCommand{metaStorageNodes=" + this.metaStorageNodes + ", cmgNodes=" + this.cmgNodes + ", clusterName='" + this.clusterName + "', clusterConfiguration='" + this.clusterConfiguration + "'}";
    }
}

