/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.rest.api.InvalidParam;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

@Schema(description="Extended description of the problem with the request.")
public class Problem {
    @Schema(description="Short summary of the issue.")
    private final String title;
    @Schema(description="Returned HTTP status code.")
    private final int status;
    @Schema(description="Ignite 3 error code.")
    private final String code;
    @Schema(description="URI to documentation regarding the issue.")
    private final String type;
    @Schema(description="Extended explanation of the issue.")
    private final String detail;
    @Schema(description="Name of the node the issue happened on.")
    private final String node;
    @Schema(description="Unique issue identifier. This identifier can be used to find logs related to the issue.")
    private final UUID traceId;
    @Schema(description="A list of parameters that did not pass validation and the reason for it.")
    private final Collection<InvalidParam> invalidParams;

    @JsonCreator
    protected Problem(@JsonProperty(value="title") String title, @JsonProperty(value="status") int status, @JsonProperty(value="code") String code, @JsonProperty(value="type") @Nullable String type, @JsonProperty(value="detail") @Nullable String detail, @JsonProperty(value="node") @Nullable String node, @JsonProperty(value="traceId") @Nullable UUID traceId, @JsonProperty(value="invalidParams") @Nullable Collection<InvalidParam> invalidParams) {
        this.title = title;
        this.status = status;
        this.code = code;
        this.type = type;
        this.detail = detail;
        this.node = node;
        this.traceId = traceId;
        this.invalidParams = invalidParams;
    }

    public static ProblemBuilder builder() {
        return new ProblemBuilder();
    }

    public static ProblemBuilder fromHttpCode(HttpCode httpCode) {
        ProblemBuilder builder = new ProblemBuilder();
        builder.status(httpCode.code());
        builder.title(httpCode.message());
        return builder;
    }

    public static ProblemBuilder fromIgniteException(IgniteException exception, HttpCode httpCode) {
        ProblemBuilder builder = new ProblemBuilder();
        builder.status(httpCode.code()).title(httpCode.message()).code(exception.codeAsString()).traceId(exception.traceId()).detail(Problem.extractDetailMessageOrNull(exception));
        return builder;
    }

    @JsonGetter(value="title")
    public String title() {
        return this.title;
    }

    @JsonGetter(value="status")
    public int status() {
        return this.status;
    }

    @JsonGetter(value="code")
    public String code() {
        return this.code;
    }

    @JsonGetter(value="type")
    public String type() {
        return this.type;
    }

    @JsonGetter(value="detail")
    public String detail() {
        return this.detail;
    }

    @JsonGetter(value="node")
    public String node() {
        return this.node;
    }

    @JsonGetter(value="traceId")
    public UUID traceId() {
        return this.traceId;
    }

    @JsonGetter(value="invalidParams")
    public Collection<InvalidParam> invalidParams() {
        return this.invalidParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return this.status == problem.status && Objects.equals(this.title, problem.title) && Objects.equals(this.code, problem.code) && Objects.equals(this.type, problem.type) && Objects.equals(this.detail, problem.detail) && Objects.equals(this.node, problem.node) && Objects.equals(this.traceId, problem.traceId);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.status, this.code, this.type, this.detail, this.node, this.traceId);
    }

    public String toString() {
        return "Problem{title='" + this.title + "', status=" + this.status + ", code='" + this.code + "', type='" + this.type + "', detail='" + this.detail + "', node='" + this.node + "', invalidParams='" + this.invalidParams + "', traceId=" + this.traceId + "}";
    }

    @Nullable
    private static String extractDetailMessageOrNull(IgniteException exception) {
        String detail = ErrorGroups.extractCauseMessage((String)exception.getMessage());
        if (detail != null && detail.isBlank()) {
            detail = null;
        }
        return detail;
    }

    public static class ProblemBuilder {
        private String title;
        private int status;
        private String code;
        private String type;
        private String detail;
        private String node;
        private UUID traceId;
        private Collection<InvalidParam> invalidParams;

        public ProblemBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ProblemBuilder status(int status) {
            this.status = status;
            return this;
        }

        public ProblemBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ProblemBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ProblemBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public ProblemBuilder node(String node) {
            this.node = node;
            return this;
        }

        public ProblemBuilder traceId(UUID traceId) {
            this.traceId = traceId;
            return this;
        }

        public ProblemBuilder invalidParams(Collection<InvalidParam> invalidParams) {
            this.invalidParams = invalidParams;
            return this;
        }

        public Problem build() {
            return new Problem(this.title, this.status, this.code, this.type, this.detail, this.node, this.traceId, this.invalidParams);
        }
    }
}

