/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.snapshot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite.internal.rest.api.snapshot.SnapshotType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

@Schema(description="Snapshot creation configuration.")
public class CreateCommand {
    @Schema(description="Type of the snapshot, FULL or INCREMENTAL.")
    private final SnapshotType snapshotType;
    @Schema(description="Set of fully-qualified table names that will be parts of the snapshot.")
    private final Set<String> tableNames;
    @Schema(description="Time for which the Snapshot should be taken in milliseconds since Unix Epoch format. If null, current time will be used")
    private final Long timestampEpochMilli;
    @Schema(description="The name of the snapshot path to the snapshot; null to use the default path.")
    private final String destination;
    @Schema(description="The encryption provider name.")
    private final String encryptionProvider;

    @JsonCreator
    public CreateCommand(@JsonProperty(value="snapshotType") SnapshotType snapshotType, @JsonProperty(value="tableNames") @Nullable Collection<String> tableNames, @JsonProperty(value="timestampEpochMilli") @Nullable Long timestampEpochMilli, @JsonProperty(value="destination") @Nullable String destination, @JsonProperty(value="encryptionProvider") @Nullable String encryptionProvider) {
        this.snapshotType = snapshotType;
        if (this.snapshotType == null) {
            throw new IllegalArgumentException("Snapshot type must be provided");
        }
        Set<Object> set = this.tableNames = tableNames == null ? Collections.emptySet() : Set.copyOf(tableNames);
        if (this.tableNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Table names must not contain blank strings: " + tableNames);
        }
        this.timestampEpochMilli = timestampEpochMilli;
        this.destination = destination;
        this.encryptionProvider = encryptionProvider;
    }

    @JsonGetter(value="snapshotType")
    public SnapshotType snapshotType() {
        return this.snapshotType;
    }

    @JsonGetter(value="tableNames")
    public Set<String> tableNames() {
        return this.tableNames;
    }

    @JsonGetter(value="timestampEpochMilli")
    public Long timestampEpochMilli() {
        return this.timestampEpochMilli;
    }

    @JsonGetter(value="destination")
    public String destination() {
        return this.destination;
    }

    @JsonGetter(value="encryptionProvider")
    public String encryptionProvider() {
        return this.encryptionProvider;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

