/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.SecondaryReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.replicator.message.SecondaryReplicaSafeTimeSyncRequestBuilder;
import org.apache.ignite.internal.replicator.message.SecondaryReplicaSafeTimeSyncRequestSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class SecondaryReplicaSafeTimeSyncRequestImpl
implements SecondaryReplicaSafeTimeSyncRequest,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 1001;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final HybridTimestamp proposedSafeTime;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private SecondaryReplicaSafeTimeSyncRequestImpl(ReplicationGroupIdMessage groupId, HybridTimestamp proposedSafeTime, int tableId, HybridTimestamp timestamp) {
        this.groupId = groupId;
        this.proposedSafeTime = proposedSafeTime;
        this.tableId = tableId;
        this.timestamp = timestamp;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public HybridTimestamp proposedSafeTime() {
        return this.proposedSafeTime;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return SecondaryReplicaSafeTimeSyncRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(SecondaryReplicaSafeTimeSyncRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1001;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SecondaryReplicaSafeTimeSyncRequestImpl otherMessage = (SecondaryReplicaSafeTimeSyncRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.proposedSafeTime, otherMessage.proposedSafeTime) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.tableId, this.groupId, this.proposedSafeTime, this.timestamp);
        return result;
    }

    public SecondaryReplicaSafeTimeSyncRequestImpl clone() {
        try {
            return (SecondaryReplicaSafeTimeSyncRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SecondaryReplicaSafeTimeSyncRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements SecondaryReplicaSafeTimeSyncRequestBuilder {
        private ReplicationGroupIdMessage groupId;
        private HybridTimestamp proposedSafeTime;
        private int tableId;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public SecondaryReplicaSafeTimeSyncRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public SecondaryReplicaSafeTimeSyncRequestBuilder proposedSafeTime(HybridTimestamp proposedSafeTime) {
            Objects.requireNonNull(proposedSafeTime, "proposedSafeTime is not marked @Nullable");
            this.proposedSafeTime = proposedSafeTime;
            return this;
        }

        @Override
        public SecondaryReplicaSafeTimeSyncRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public SecondaryReplicaSafeTimeSyncRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public HybridTimestamp proposedSafeTime() {
            return this.proposedSafeTime;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public SecondaryReplicaSafeTimeSyncRequest build() {
            return new SecondaryReplicaSafeTimeSyncRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.proposedSafeTime, "proposedSafeTime is not marked @Nullable"), this.tableId, this.timestamp);
        }

        @Override
        public SecondaryReplicaSafeTimeSyncRequest buildDeserialized() {
            return new SecondaryReplicaSafeTimeSyncRequestImpl(this.groupId, this.proposedSafeTime, this.tableId, this.timestamp);
        }
    }
}

