/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommand;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommandImpl;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesTypeInfos;

class PrimaryReplicaChangeCommandSerializer
implements MessageSerializer<PrimaryReplicaChangeCommand> {
    public static final PrimaryReplicaChangeCommandSerializer INSTANCE = new PrimaryReplicaChangeCommandSerializer();

    private PrimaryReplicaChangeCommandSerializer() {
    }

    public boolean writeMessage(PrimaryReplicaChangeCommand msg, MessageWriter writer) throws MessageMappingException {
        PrimaryReplicaChangeCommandImpl message = (PrimaryReplicaChangeCommandImpl)msg;
        writer.setMessageTypeInfo(ReplicaMessagesTypeInfos.primaryReplicaChangeCommand());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("leaseStartTime", message.leaseStartTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("primaryReplicaNodeId", message.primaryReplicaNodeId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("primaryReplicaNodeName", message.primaryReplicaNodeName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

