/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommand;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommandBuilder;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesTypeInfos;

class PrimaryReplicaChangeCommandDeserializer
implements MessageDeserializer<PrimaryReplicaChangeCommand> {
    private final PrimaryReplicaChangeCommandBuilder msg;

    PrimaryReplicaChangeCommandDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.primaryReplicaChangeCommand();
    }

    public Class<PrimaryReplicaChangeCommand> klass() {
        return PrimaryReplicaChangeCommand.class;
    }

    public PrimaryReplicaChangeCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ReplicaMessagesTypeInfos.primaryReplicaChangeCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaseStartTime(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("primaryReplicaNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.primaryReplicaNodeId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readString("primaryReplicaNodeName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.primaryReplicaNodeName((String)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PrimaryReplicaChangeCommand.class);
    }
}

