/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.AwaitReplicaRequest;
import org.apache.ignite.internal.replicator.message.AwaitReplicaRequestBuilder;
import org.apache.ignite.internal.replicator.message.AwaitReplicaRequestSerializer;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class AwaitReplicaRequestImpl
implements AwaitReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 6;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;

    private AwaitReplicaRequestImpl(ReplicationGroupIdMessage groupId) {
        this.groupId = groupId;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    public MessageSerializer serializer() {
        return AwaitReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(AwaitReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AwaitReplicaRequestImpl otherMessage = (AwaitReplicaRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId);
        return result;
    }

    public AwaitReplicaRequestImpl clone() {
        try {
            return (AwaitReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AwaitReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements AwaitReplicaRequestBuilder {
        private ReplicationGroupIdMessage groupId;

        private Builder() {
        }

        @Override
        public AwaitReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public AwaitReplicaRequest build() {
            return new AwaitReplicaRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"));
        }

        @Override
        public AwaitReplicaRequest buildDeserialized() {
            return new AwaitReplicaRequestImpl(this.groupId);
        }
    }
}

