/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesTypeInfos;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessageImpl;

class ZonePartitionIdMessageSerializer
implements MessageSerializer<ZonePartitionIdMessage> {
    public static final ZonePartitionIdMessageSerializer INSTANCE = new ZonePartitionIdMessageSerializer();

    private ZonePartitionIdMessageSerializer() {
    }

    public boolean writeMessage(ZonePartitionIdMessage msg, MessageWriter writer) throws MessageMappingException {
        ZonePartitionIdMessageImpl message = (ZonePartitionIdMessageImpl)msg;
        writer.setMessageTypeInfo(ReplicaMessagesTypeInfos.zonePartitionIdMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("partitionId", message.partitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeInt("zoneId", message.zoneId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

