/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesTypeInfos;
import org.apache.ignite.internal.replicator.message.TimestampAwareReplicaResponse;
import org.apache.ignite.internal.replicator.message.TimestampAwareReplicaResponseImpl;

class TimestampAwareReplicaResponseSerializer
implements MessageSerializer<TimestampAwareReplicaResponse> {
    public static final TimestampAwareReplicaResponseSerializer INSTANCE = new TimestampAwareReplicaResponseSerializer();

    private TimestampAwareReplicaResponseSerializer() {
    }

    public boolean writeMessage(TimestampAwareReplicaResponse msg, MessageWriter writer) throws MessageMappingException {
        TimestampAwareReplicaResponseImpl message = (TimestampAwareReplicaResponseImpl)msg;
        writer.setMessageTypeInfo(ReplicaMessagesTypeInfos.timestampAwareReplicaResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteArray("resultByteArray", message.resultByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

