/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesTypeInfos;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.replicator.message.ReplicaResponseBuilder;

class ReplicaResponseDeserializer
implements MessageDeserializer<ReplicaResponse> {
    private final ReplicaResponseBuilder msg;

    ReplicaResponseDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.replicaResponse();
    }

    public Class<ReplicaResponse> klass() {
        return ReplicaResponse.class;
    }

    public ReplicaResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ReplicaMessagesTypeInfos.replicaResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("resultByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.resultByteArray(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReplicaResponse.class);
    }
}

