/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.SnapshotRequestBuilder;

class SnapshotRequestDeserializer
implements MessageDeserializer<CliRequests.SnapshotRequest> {
    private final SnapshotRequestBuilder msg;

    SnapshotRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotRequest();
    }

    public Class<CliRequests.SnapshotRequest> klass() {
        return CliRequests.SnapshotRequest.class;
    }

    public CliRequests.SnapshotRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.snapshotRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("forced");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.forced(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                String tmp = reader.readString("peerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.peerId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CliRequests.SnapshotRequest.class);
    }
}

