/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.RequestVoteResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RequestVoteResponseSerializer;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class RequestVoteResponseImpl
implements RpcRequests.RequestVoteResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3007;
    @IgniteToStringInclude
    private final boolean granted;
    @IgniteToStringInclude
    private final long term;

    private RequestVoteResponseImpl(boolean granted, long term) {
        this.granted = granted;
        this.term = term;
    }

    @Override
    public boolean granted() {
        return this.granted;
    }

    @Override
    public long term() {
        return this.term;
    }

    public MessageSerializer serializer() {
        return RequestVoteResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(RequestVoteResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 3007;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RequestVoteResponseImpl otherMessage = (RequestVoteResponseImpl)other;
        return this.granted == otherMessage.granted && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.granted, this.term);
        return result;
    }

    public RequestVoteResponseImpl clone() {
        try {
            return (RequestVoteResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RequestVoteResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RequestVoteResponseBuilder {
        private boolean granted;
        private long term;

        private Builder() {
        }

        @Override
        public RequestVoteResponseBuilder granted(boolean granted) {
            this.granted = granted;
            return this;
        }

        @Override
        public RequestVoteResponseBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public boolean granted() {
            return this.granted;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public RpcRequests.RequestVoteResponse build() {
            return new RequestVoteResponseImpl(this.granted, this.term);
        }

        @Override
        public RpcRequests.RequestVoteResponse buildDeserialized() {
            return new RequestVoteResponseImpl(this.granted, this.term);
        }
    }
}

