/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.core;

import com.codahale.metrics.Metric;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.FSMCaller;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.StateMachine;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.closure.ClosureQueue;
import org.apache.ignite.raft.jraft.closure.LoadSnapshotClosure;
import org.apache.ignite.raft.jraft.closure.SaveSnapshotClosure;
import org.apache.ignite.raft.jraft.closure.TaskClosure;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.conf.ConfigurationEntry;
import org.apache.ignite.raft.jraft.core.IteratorImpl;
import org.apache.ignite.raft.jraft.core.IteratorWrapper;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.core.NodeMetrics;
import org.apache.ignite.raft.jraft.disruptor.DisruptorEventType;
import org.apache.ignite.raft.jraft.disruptor.NodeIdAware;
import org.apache.ignite.raft.jraft.disruptor.StripedDisruptor;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LeaderChangeContext;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.NodeId;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.entity.SnapshotMetaBuilder;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RaftException;
import org.apache.ignite.raft.jraft.option.FSMCallerOptions;
import org.apache.ignite.raft.jraft.storage.LogManager;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;
import org.apache.ignite.raft.jraft.util.Describer;
import org.apache.ignite.raft.jraft.util.DisruptorMetricSet;
import org.apache.ignite.raft.jraft.util.OnlyForTest;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.Utils;

public class FSMCallerImpl
implements FSMCaller {
    private static final IgniteLogger LOG = Loggers.forClass(FSMCallerImpl.class);
    private NodeId nodeId;
    private LogManager logManager;
    private StateMachine fsm;
    private ClosureQueue closureQueue;
    private final AtomicLong lastAppliedIndex;
    private long lastAppliedTerm;
    private Closure afterShutdown;
    private NodeImpl node;
    private volatile TaskType currTask;
    private final AtomicLong applyingIndex;
    private volatile RaftException error;
    private StripedDisruptor<ApplyTask> disruptor;
    private RingBuffer<ApplyTask> taskQueue;
    private volatile CountDownLatch shutdownLatch;
    private NodeMetrics nodeMetrics;
    private final CopyOnWriteArrayList<FSMCaller.LastAppliedLogIndexListener> lastAppliedLogIndexListeners = new CopyOnWriteArrayList();
    private RaftMessagesFactory msgFactory;
    private volatile boolean shuttingDown;

    public FSMCallerImpl() {
        this.currTask = TaskType.IDLE;
        this.lastAppliedIndex = new AtomicLong(0L);
        this.applyingIndex = new AtomicLong(0L);
    }

    @Override
    public boolean init(FSMCallerOptions opts) {
        this.nodeId = opts.getNode().getNodeId();
        this.logManager = opts.getLogManager();
        this.fsm = opts.getFsm();
        this.closureQueue = opts.getClosureQueue();
        this.afterShutdown = opts.getAfterShutdown();
        this.node = opts.getNode();
        this.nodeMetrics = this.node.getNodeMetrics();
        this.lastAppliedIndex.set(opts.getBootstrapId().getIndex());
        this.notifyLastAppliedIndexUpdated(this.lastAppliedIndex.get());
        this.lastAppliedTerm = opts.getBootstrapId().getTerm();
        this.disruptor = opts.getfSMCallerExecutorDisruptor();
        this.taskQueue = this.disruptor.subscribe(this.nodeId, new ApplyTaskHandler());
        if (this.nodeMetrics.getMetricRegistry() != null) {
            this.nodeMetrics.getMetricRegistry().register("jraft-fsm-caller-disruptor", (Metric)new DisruptorMetricSet(this.taskQueue));
        }
        this.error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_NONE);
        this.msgFactory = opts.getRaftMessagesFactory();
        LOG.info("Starts FSMCaller successfully [node={}].", new Object[]{this.node.getNodeId()});
        return true;
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdownLatch != null) {
            return;
        }
        LOG.info("Shutting down FSMCaller [node={}].", new Object[]{this.node.getNodeId()});
        this.shuttingDown = true;
        if (this.taskQueue != null) {
            CountDownLatch latch;
            this.shutdownLatch = latch = new CountDownLatch(1);
            Utils.runInThread(this.node.getOptions().getCommonExecutor(), () -> this.taskQueue.publishEvent((task, sequence) -> {
                task.reset();
                task.nodeId = this.nodeId;
                task.type = TaskType.SHUTDOWN;
                task.shutdownLatch = latch;
            }));
        }
    }

    @Override
    public void addLastAppliedLogIndexListener(FSMCaller.LastAppliedLogIndexListener listener) {
        this.lastAppliedLogIndexListeners.add(listener);
    }

    @Override
    public void removeLastAppliedLogIndexListener(FSMCaller.LastAppliedLogIndexListener listener) {
        this.lastAppliedLogIndexListeners.remove(listener);
    }

    private boolean enqueueTask(EventTranslator<ApplyTask> tpl) {
        if (this.shutdownLatch != null) {
            LOG.warn("FSMCaller is stopped, can not apply new task [node={}].", new Object[]{this.nodeId});
            return false;
        }
        this.taskQueue.publishEvent(tpl);
        return true;
    }

    @Override
    public boolean onCommitted(long committedIndex) {
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.COMMITTED;
            task.committedIndex = committedIndex;
        }));
    }

    @OnlyForTest
    void flush() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.FLUSH;
            task.shutdownLatch = latch;
        }));
        latch.await();
    }

    @Override
    public boolean onSnapshotLoad(LoadSnapshotClosure done) {
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.SNAPSHOT_LOAD;
            task.done = done;
        }));
    }

    @Override
    public boolean onSnapshotSave(SaveSnapshotClosure done) {
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.SNAPSHOT_SAVE;
            task.done = done;
        }));
    }

    @Override
    public boolean onLeaderStop(Status status) {
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.LEADER_STOP;
            task.status = new Status(status);
        }));
    }

    @Override
    public boolean onLeaderStart(long term) {
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.LEADER_START;
            task.term = term;
        }));
    }

    @Override
    public boolean onStartFollowing(LeaderChangeContext ctx) {
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.START_FOLLOWING;
            task.leaderChangeCtx = new LeaderChangeContext(ctx.getLeaderId(), ctx.getTerm(), ctx.getStatus());
        }));
    }

    @Override
    public boolean onStopFollowing(LeaderChangeContext ctx) {
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.STOP_FOLLOWING;
            task.leaderChangeCtx = new LeaderChangeContext(ctx.getLeaderId(), ctx.getTerm(), ctx.getStatus());
        }));
    }

    @Override
    public boolean onError(RaftException error) {
        if (!this.error.getStatus().isOk()) {
            LOG.warn("FSMCaller already in error status, ignore new error [node={}].", new Object[]{this.nodeId, error});
            return false;
        }
        OnErrorClosure c = new OnErrorClosure(error);
        return this.enqueueTask((EventTranslator<ApplyTask>)((EventTranslator)(task, sequence) -> {
            task.nodeId = this.nodeId;
            task.handler = null;
            task.evtType = DisruptorEventType.REGULAR;
            task.type = TaskType.ERROR;
            task.done = c;
        }));
    }

    @Override
    public long getLastAppliedIndex() {
        return this.lastAppliedIndex.get();
    }

    @Override
    public synchronized void join() throws InterruptedException {
        if (this.shutdownLatch != null) {
            this.shutdownLatch.await();
            this.disruptor.unsubscribe(this.nodeId);
            if (this.afterShutdown != null) {
                this.afterShutdown.run(Status.OK());
                this.afterShutdown = null;
            }
            this.shutdownLatch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long runApplyTask(ApplyTask task, long maxCommittedIndex, boolean endOfBatch) {
        shutdown = null;
        if (task.type == TaskType.COMMITTED) {
            if (task.committedIndex > maxCommittedIndex) {
                maxCommittedIndex = task.committedIndex;
            }
            task.reset();
        } else {
            if (maxCommittedIndex >= 0L) {
                this.currTask = TaskType.COMMITTED;
                this.doCommitted(maxCommittedIndex);
                maxCommittedIndex = -1L;
            }
            startMs = Utils.monotonicMs();
            try {
                switch (1.$SwitchMap$org$apache$ignite$raft$jraft$core$FSMCallerImpl$TaskType[task.type.ordinal()]) {
                    case 1: {
                        Requires.requireTrue(false, "Impossible");
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        this.currTask = TaskType.SNAPSHOT_SAVE;
                        if (!this.passByStatus(task.done)) ** break;
                        this.doSnapshotSave((SaveSnapshotClosure)task.done);
                        ** break;
lbl23:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.currTask = TaskType.SNAPSHOT_LOAD;
                        if (!this.passByStatus(task.done)) ** break;
                        this.doSnapshotLoad((LoadSnapshotClosure)task.done);
                        ** break;
lbl29:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        this.currTask = TaskType.LEADER_STOP;
                        this.doLeaderStop(task.status);
                        ** break;
lbl34:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        this.currTask = TaskType.LEADER_START;
                        this.doLeaderStart(task.term);
                        ** break;
lbl39:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        this.currTask = TaskType.START_FOLLOWING;
                        this.doStartFollowing(task.leaderChangeCtx);
                        ** break;
lbl44:
                        // 1 sources

                        break;
                    }
                    case 7: {
                        this.currTask = TaskType.STOP_FOLLOWING;
                        this.doStopFollowing(task.leaderChangeCtx);
                        ** break;
lbl49:
                        // 1 sources

                        break;
                    }
                    case 8: {
                        this.currTask = TaskType.ERROR;
                        this.doOnError((OnErrorClosure)task.done);
                        ** break;
lbl54:
                        // 1 sources

                        break;
                    }
                    case 9: {
                        Requires.requireTrue(false, "Can't reach here");
                        ** break;
lbl58:
                        // 1 sources

                        break;
                    }
                    case 10: {
                        this.currTask = TaskType.SHUTDOWN;
                        shutdown = task.shutdownLatch;
                        this.doShutdown();
                        ** break;
lbl64:
                        // 1 sources

                        break;
                    }
                    case 11: {
                        this.currTask = TaskType.FLUSH;
                        shutdown = task.shutdownLatch;
                        break;
                    }
                    ** default:
lbl70:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.nodeMetrics.recordLatency(task.type.metricName(), Utils.monotonicMs() - startMs);
                task.reset();
            }
        }
        try {
            if (endOfBatch && maxCommittedIndex >= 0L) {
                this.currTask = TaskType.COMMITTED;
                this.doCommitted(maxCommittedIndex);
                maxCommittedIndex = -1L;
            }
            this.currTask = TaskType.IDLE;
            var6_5 = maxCommittedIndex;
            return var6_5;
        }
        finally {
            if (shutdown != null) {
                shutdown.countDown();
            }
        }
    }

    private void doShutdown() {
        if (this.node != null) {
            this.node = null;
        }
        if (this.fsm != null) {
            this.fsm.onShutdown();
        }
    }

    private void notifyLastAppliedIndexUpdated(long lastAppliedIndex) {
        for (FSMCaller.LastAppliedLogIndexListener listener : this.lastAppliedLogIndexListeners) {
            listener.onApplied(lastAppliedIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommitted(long committedIndex) {
        if (!this.error.getStatus().isOk()) {
            return;
        }
        long lastAppliedIndex = this.lastAppliedIndex.get();
        if (lastAppliedIndex >= committedIndex) {
            return;
        }
        long startMs = Utils.monotonicMs();
        try {
            ArrayList<Closure> closures = new ArrayList<Closure>();
            ArrayList<TaskClosure> taskClosures = new ArrayList<TaskClosure>();
            long firstClosureIndex = this.closureQueue.popClosureUntil(committedIndex, closures, taskClosures);
            this.onTaskCommitted(taskClosures);
            Requires.requireTrue(firstClosureIndex >= 0L, "Invalid firstClosureIndex");
            IteratorImpl iterImpl = new IteratorImpl(this.fsm, this.logManager, closures, firstClosureIndex, lastAppliedIndex, committedIndex, this.applyingIndex, this.node.getOptions());
            while (!this.shuttingDown && iterImpl.isGood()) {
                LogEntry logEntry = iterImpl.entry();
                if (logEntry.getType() != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
                    if (logEntry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                        LogId logId = logEntry.getId();
                        ConfigurationEntry configurationEntry = new ConfigurationEntry(logId.copy(), new Configuration(logEntry.getPeers(), logEntry.getLearners(), logEntry.getSequenceToken()), new Configuration(logEntry.getOldSequenceToken()));
                        if (logEntry.getOldPeers() != null && !logEntry.getOldPeers().isEmpty()) {
                            configurationEntry.setOldConf(new Configuration(logEntry.getOldPeers(), logEntry.getOldLearners(), logEntry.getOldSequenceToken()));
                        }
                        this.fsm.onRawConfigurationCommitted(configurationEntry, logId.getIndex(), logId.getTerm());
                        if (logEntry.getOldPeers() != null && !logEntry.getOldPeers().isEmpty()) {
                            this.fsm.onConfigurationCommitted(new Configuration(iterImpl.entry().getPeers(), iterImpl.entry().getSequenceToken()));
                        }
                    }
                    if (iterImpl.done() != null) {
                        iterImpl.done().run(Status.OK());
                    }
                    iterImpl.next();
                    continue;
                }
                this.doApplyTasks(iterImpl);
            }
            if (iterImpl.hasError()) {
                this.setError(iterImpl.getError());
                iterImpl.runTheRestClosureWithError();
            } else if (this.shuttingDown) {
                iterImpl.runTheRestClosureWithShutdownException();
            }
            long lastIndex = iterImpl.getIndex() - 1L;
            long lastTerm = this.logManager.getTerm(lastIndex);
            LogId lastAppliedId = new LogId(lastIndex, lastTerm);
            this.lastAppliedIndex.set(lastIndex);
            this.lastAppliedTerm = lastTerm;
            this.logManager.setAppliedId(lastAppliedId);
            this.notifyLastAppliedIndexUpdated(lastIndex);
        }
        finally {
            this.nodeMetrics.recordLatency("fsm-commit", Utils.monotonicMs() - startMs);
        }
    }

    private void onTaskCommitted(List<TaskClosure> closures) {
        int size = closures.size();
        for (int i = 0; i < size; ++i) {
            TaskClosure done = closures.get(i);
            done.onCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyTasks(IteratorImpl iterImpl) {
        IteratorWrapper iter = new IteratorWrapper(iterImpl, () -> this.shuttingDown);
        long startApplyMs = Utils.monotonicMs();
        long startIndex = iter.getIndex();
        try {
            this.fsm.onApply(iter);
        }
        finally {
            this.nodeMetrics.recordLatency("fsm-apply-tasks", Utils.monotonicMs() - startApplyMs);
            this.nodeMetrics.recordSize("fsm-apply-tasks-count", iter.getIndex() - startIndex);
        }
        if (iter.hasNext()) {
            LOG.error("Iterator is still valid, did you return before iterator reached the end? [node={}].", new Object[]{this.node.getNodeId()});
        }
        if (!this.shuttingDown) {
            iter.next();
        }
    }

    private void doSnapshotSave(SaveSnapshotClosure done) {
        SnapshotWriter writer;
        Requires.requireNonNull(done, "SaveSnapshotClosure is null");
        long lastAppliedIndex = this.lastAppliedIndex.get();
        ConfigurationEntry confEntry = this.logManager.getConfiguration(lastAppliedIndex);
        if (confEntry == null || confEntry.isEmpty()) {
            LOG.error("Empty conf entry for [node={}, lastAppliedIndex={}].", new Object[]{this.node.getNodeId(), lastAppliedIndex});
            Utils.runClosureInThread(this.node.getOptions().getCommonExecutor(), done, new Status(RaftError.EINVAL, "Empty conf entry for lastAppliedIndex=%s", lastAppliedIndex));
            return;
        }
        SnapshotMetaBuilder metaBuilder = this.msgFactory.snapshotMeta().cfgIndex(confEntry.getId().getIndex()).cfgTerm(confEntry.getId().getTerm()).lastIncludedIndex(lastAppliedIndex).lastIncludedTerm(this.lastAppliedTerm).peersList(confEntry.getConf().getPeers().stream().map(Object::toString).collect(Collectors.toList())).learnersList(confEntry.getConf().getLearners().stream().map(Object::toString).collect(Collectors.toList()));
        if (confEntry.getOldConf() != null) {
            metaBuilder.oldPeersList(confEntry.getOldConf().getPeers().stream().map(Object::toString).collect(Collectors.toList())).oldLearnersList(confEntry.getOldConf().getLearners().stream().map(Object::toString).collect(Collectors.toList()));
        }
        if ((writer = done.start(metaBuilder.build())) == null) {
            done.run(new Status(RaftError.EINVAL, "snapshot_storage create SnapshotWriter failed", new Object[0]));
            return;
        }
        this.fsm.onSnapshotSave(writer, done);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StateMachine [");
        switch (this.currTask) {
            case IDLE: {
                sb.append("Idle");
                break;
            }
            case COMMITTED: {
                sb.append("Applying logIndex=").append(this.applyingIndex);
                break;
            }
            case SNAPSHOT_SAVE: {
                sb.append("Saving snapshot");
                break;
            }
            case SNAPSHOT_LOAD: {
                sb.append("Loading snapshot");
                break;
            }
            case ERROR: {
                sb.append("Notifying error");
                break;
            }
            case LEADER_STOP: {
                sb.append("Notifying leader stop");
                break;
            }
            case LEADER_START: {
                sb.append("Notifying leader start");
                break;
            }
            case START_FOLLOWING: {
                sb.append("Notifying start following");
                break;
            }
            case STOP_FOLLOWING: {
                sb.append("Notifying stop following");
                break;
            }
            case SHUTDOWN: {
                sb.append("Shutting down");
                break;
            }
        }
        return sb.append(']').toString();
    }

    private void doSnapshotLoad(LoadSnapshotClosure done) {
        LogId snapshotId;
        Requires.requireNonNull(done, "LoadSnapshotClosure is null");
        SnapshotReader reader = done.start();
        if (reader == null) {
            done.run(new Status(RaftError.EINVAL, "open SnapshotReader failed", new Object[0]));
            return;
        }
        RaftOutter.SnapshotMeta meta = reader.load();
        if (meta == null) {
            done.run(new Status(RaftError.EINVAL, "SnapshotReader load meta failed", new Object[0]));
            if (reader.getRaftError() == RaftError.EIO) {
                RaftException err = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_SNAPSHOT, RaftError.EIO, "Fail to load snapshot meta", new Object[0]);
                this.setError(err);
            }
            return;
        }
        LogId lastAppliedId = new LogId(this.lastAppliedIndex.get(), this.lastAppliedTerm);
        if (lastAppliedId.compareTo(snapshotId = new LogId(meta.lastIncludedIndex(), meta.lastIncludedTerm())) > 0) {
            done.run(new Status(RaftError.ESTALE, "Loading a stale snapshot last_applied_index=%d last_applied_term=%d snapshot_index=%d snapshot_term=%d", lastAppliedId.getIndex(), lastAppliedId.getTerm(), snapshotId.getIndex(), snapshotId.getTerm()));
            return;
        }
        if (!this.fsm.onSnapshotLoad(reader)) {
            done.run(new Status(-1, "StateMachine onSnapshotLoad failed"));
            RaftException e = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_STATE_MACHINE, RaftError.ESTATEMACHINE, "StateMachine onSnapshotLoad failed", new Object[0]);
            this.setError(e);
            return;
        }
        if (meta.peersList() != null && meta.learnersList() != null) {
            ConfigurationEntry configurationEntry = new ConfigurationEntry(new LogId(meta.cfgIndex(), meta.cfgTerm()), new Configuration(meta.peersList().stream().map(PeerId::parsePeer).collect(Collectors.toList()), meta.learnersList().stream().map(PeerId::parsePeer).collect(Collectors.toList()), meta.sequenceToken()), new Configuration(meta.oldSequenceToken()));
            if (meta.oldPeersList() != null && !meta.oldPeersList().isEmpty()) {
                configurationEntry.setOldConf(new Configuration(meta.oldPeersList().stream().map(PeerId::parsePeer).collect(Collectors.toList()), meta.oldLearnersList().stream().map(PeerId::parsePeer).collect(Collectors.toList()), meta.oldSequenceToken()));
            }
            this.fsm.onRawConfigurationCommitted(configurationEntry, snapshotId.getIndex(), snapshotId.getTerm());
        }
        if (meta.oldPeersList() == null) {
            Configuration conf = new Configuration(meta.sequenceToken());
            if (meta.peersList() != null) {
                for (String metaPeer : meta.peersList()) {
                    PeerId peer = new PeerId();
                    Requires.requireTrue(peer.parse(metaPeer), "Parse peer failed");
                    conf.addPeer(peer);
                }
            }
            this.fsm.onConfigurationCommitted(conf);
        }
        this.lastAppliedIndex.set(meta.lastIncludedIndex());
        this.lastAppliedTerm = meta.lastIncludedTerm();
        done.run(Status.OK());
    }

    private void doOnError(OnErrorClosure done) {
        this.setError(done.getError());
    }

    private void doLeaderStop(Status status) {
        this.fsm.onLeaderStop(status);
    }

    private void doLeaderStart(long term) {
        this.fsm.onLeaderStart(term);
    }

    private void doStartFollowing(LeaderChangeContext ctx) {
        this.fsm.onStartFollowing(ctx);
    }

    private void doStopFollowing(LeaderChangeContext ctx) {
        this.fsm.onStopFollowing(ctx);
    }

    private void setError(RaftException e) {
        if (this.error.getType() != EnumOutter.ErrorType.ERROR_TYPE_NONE) {
            return;
        }
        this.error = e;
        if (this.fsm != null) {
            this.fsm.onError(e);
        }
        if (this.node != null) {
            this.node.onError(e);
        }
    }

    @OnlyForTest
    RaftException getError() {
        return this.error;
    }

    private boolean passByStatus(Closure done) {
        Status status = this.error.getStatus();
        if (!status.isOk() && done != null) {
            done.run(new Status(RaftError.EINVAL, "FSMCaller is in bad status=`%s`", status));
            return false;
        }
        return true;
    }

    @Override
    public void describe(Describer.Printer out) {
        out.print("  ").println(this.toString());
    }

    public static enum TaskType {
        IDLE,
        COMMITTED,
        SNAPSHOT_SAVE,
        SNAPSHOT_LOAD,
        LEADER_STOP,
        LEADER_START,
        START_FOLLOWING,
        STOP_FOLLOWING,
        SHUTDOWN,
        FLUSH,
        ERROR;

        private String metricName;

        public String metricName() {
            if (this.metricName == null) {
                this.metricName = "fsm-" + this.name().toLowerCase().replaceAll("_", "-");
            }
            return this.metricName;
        }
    }

    private class ApplyTaskHandler
    implements EventHandler<ApplyTask> {
        private long maxCommittedIndex = -1L;

        private ApplyTaskHandler() {
        }

        public void onEvent(ApplyTask event, long sequence, boolean endOfBatch) throws Exception {
            this.maxCommittedIndex = FSMCallerImpl.this.runApplyTask(event, this.maxCommittedIndex, endOfBatch);
        }
    }

    public class OnErrorClosure
    implements Closure {
        private RaftException error;

        public OnErrorClosure(RaftException error) {
            this.error = error;
        }

        public RaftException getError() {
            return this.error;
        }

        public void setError(RaftException error) {
            this.error = error;
        }

        @Override
        public void run(Status st) {
        }
    }

    public static class ApplyTask
    extends NodeIdAware {
        public TaskType type;
        public long committedIndex;
        long term;
        Status status;
        LeaderChangeContext leaderChangeCtx;
        Closure done;
        public CountDownLatch shutdownLatch;

        @Override
        public void reset() {
            super.reset();
            this.type = null;
            this.committedIndex = 0L;
            this.term = 0L;
            this.status = null;
            this.leaderChangeCtx = null;
            this.done = null;
            this.shutdownLatch = null;
        }
    }
}

