/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.ignite.internal.raft.storage.segstore.IndexMemTable;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFile;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFileManager;
import org.apache.ignite.internal.raft.storage.segstore.WriteModeIndexMemTable;
import org.apache.ignite.internal.raft.util.VarlenEncoder;
import org.apache.ignite.internal.util.FastCrc;

class SegmentPayloadParser {
    private final int stripes;

    SegmentPayloadParser(int stripes) {
        this.stripes = stripes;
    }

    WriteModeIndexMemTable recoverMemtable(SegmentFile segmentFile, Path segmentFilePath, boolean validateCrc) {
        ByteBuffer buffer = segmentFile.buffer();
        SegmentPayloadParser.validateSegmentFileHeader(buffer, segmentFilePath);
        IndexMemTable memtable = new IndexMemTable(this.stripes);
        while (!SegmentPayloadParser.endOfSegmentReached(buffer)) {
            int crcPosition;
            int segmentFilePayloadOffset = buffer.position();
            long groupId = buffer.getLong();
            int payloadLength = buffer.getInt();
            if (payloadLength == 0) {
                long lastLogIndexKept = buffer.getLong();
                crcPosition = buffer.position();
                buffer.position(segmentFilePayloadOffset);
                if (validateCrc && !SegmentPayloadParser.isCrcValid(buffer, crcPosition)) break;
                memtable.truncateSuffix(groupId, lastLogIndexKept);
            } else if (payloadLength == -1) {
                long firstLogIndexKept = buffer.getLong();
                crcPosition = buffer.position();
                buffer.position(segmentFilePayloadOffset);
                if (validateCrc && !SegmentPayloadParser.isCrcValid(buffer, crcPosition)) break;
                memtable.truncatePrefix(groupId, firstLogIndexKept);
            } else if (payloadLength == -2) {
                long nextLogIndex = buffer.getLong();
                crcPosition = buffer.position();
                buffer.position(segmentFilePayloadOffset);
                if (validateCrc && !SegmentPayloadParser.isCrcValid(buffer, crcPosition)) break;
                memtable.reset(groupId, nextLogIndex);
            } else {
                crcPosition = buffer.position() + payloadLength;
                long index = VarlenEncoder.readLong(buffer);
                buffer.position(segmentFilePayloadOffset);
                if (validateCrc && !SegmentPayloadParser.isCrcValid(buffer, crcPosition)) break;
                memtable.appendSegmentFileOffset(groupId, index, segmentFilePayloadOffset);
            }
            buffer.position(crcPosition + 4);
        }
        return memtable;
    }

    private static void validateSegmentFileHeader(ByteBuffer buffer, Path segmentFilePath) {
        int magicNumber = buffer.getInt();
        if (magicNumber != 1457567014) {
            throw new IllegalStateException(String.format("Invalid magic number in segment file %s: %d.", segmentFilePath, magicNumber));
        }
        int formatVersion = buffer.getInt();
        if (formatVersion > 1) {
            throw new IllegalStateException(String.format("Unsupported format version in segment file %s: %d.", segmentFilePath, formatVersion));
        }
    }

    private static boolean isCrcValid(ByteBuffer buffer, int crcPosition) {
        int originalPosition = buffer.position();
        int crc = buffer.getInt(crcPosition);
        int expectedCrc = FastCrc.calcCrc((ByteBuffer)buffer, (int)(crcPosition - buffer.position()));
        buffer.position(originalPosition);
        return crc == expectedCrc;
    }

    private static boolean endOfSegmentReached(ByteBuffer buffer) {
        if (buffer.remaining() < SegmentFileManager.SWITCH_SEGMENT_RECORD.length) {
            return true;
        }
        byte[] switchSegmentRecordBytes = new byte[SegmentFileManager.SWITCH_SEGMENT_RECORD.length];
        int originalPos = buffer.position();
        buffer.get(switchSegmentRecordBytes);
        buffer.position(originalPos);
        return Arrays.equals(switchSegmentRecordBytes, SegmentFileManager.SWITCH_SEGMENT_RECORD);
    }
}

