/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.raft.util.VarlenEncoder;
import org.apache.ignite.internal.util.FastCrc;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;

class SegmentPayload {
    static final int GROUP_ID_SIZE_BYTES = 8;
    static final int LENGTH_SIZE_BYTES = 4;
    static final int CRC_SIZE_BYTES = 4;
    static final int TRUNCATE_SUFFIX_RECORD_SIZE = 24;
    static final int TRUNCATE_PREFIX_RECORD_SIZE = 24;
    static final int RESET_RECORD_SIZE = 24;
    static final int TRUNCATE_SUFFIX_RECORD_MARKER = 0;
    static final int TRUNCATE_PREFIX_RECORD_MARKER = -1;
    static final int RESET_RECORD_MARKER = -2;

    SegmentPayload() {
    }

    static void writeTo(ByteBuffer buffer, long groupId, int segmentEntrySize, LogEntry logEntry, LogEntryEncoder logEntryEncoder) {
        int originalPos = buffer.position();
        buffer.putLong(groupId).putInt(segmentEntrySize - SegmentPayload.fixedOverheadSize());
        LogId logId = logEntry.getId();
        VarlenEncoder.writeLong(logId.getIndex(), buffer);
        VarlenEncoder.writeLong(logId.getTerm(), buffer);
        logEntryEncoder.encode(buffer, logEntry);
        int recordSize = buffer.position() - originalPos;
        SegmentPayload.writeCrc(buffer, recordSize);
    }

    static void writeTruncateSuffixRecordTo(ByteBuffer buffer, long groupId, long lastLogIndexKept) {
        buffer.putLong(groupId).putInt(0).putLong(lastLogIndexKept);
        SegmentPayload.writeCrc(buffer, 20);
    }

    static void writeTruncatePrefixRecordTo(ByteBuffer buffer, long groupId, long firstIndexKept) {
        buffer.putLong(groupId).putInt(-1).putLong(firstIndexKept);
        SegmentPayload.writeCrc(buffer, 20);
    }

    static void writeResetRecordTo(ByteBuffer buffer, long groupId, long nextLogIndex) {
        buffer.putLong(groupId).putInt(-2).putLong(nextLogIndex);
        SegmentPayload.writeCrc(buffer, 20);
    }

    private static void writeCrc(ByteBuffer buffer, int recordSizeWithoutCrc) {
        buffer.position(buffer.position() - recordSizeWithoutCrc);
        int crc = FastCrc.calcCrc((ByteBuffer)buffer, (int)recordSizeWithoutCrc);
        buffer.putInt(crc);
    }

    static LogEntry readFrom(ByteBuffer buffer, LogEntryDecoder logEntryDecoder) {
        int originalPosition = buffer.position();
        buffer.position(originalPosition + 8);
        int payloadLength = buffer.getInt();
        int payloadPosition = buffer.position();
        VarlenEncoder.readLong(buffer);
        VarlenEncoder.readLong(buffer);
        int logEntryPosition = buffer.position();
        int crcPosition = payloadPosition + payloadLength;
        int crc = buffer.getInt(crcPosition);
        buffer.position(originalPosition);
        int actualCrc = FastCrc.calcCrc((ByteBuffer)buffer, (int)(crcPosition - originalPosition));
        if (crc != actualCrc) {
            throw new IllegalStateException("CRC mismatch, expected: " + crc + ", actual: " + actualCrc);
        }
        buffer.position(logEntryPosition);
        byte[] entryBytes = new byte[crcPosition - logEntryPosition];
        buffer.get(entryBytes);
        buffer.position(buffer.position() + 4);
        return logEntryDecoder.decode(entryBytes);
    }

    static int size(LogEntry logEntry, LogEntryEncoder logEntryEncoder) {
        int entrySize = logEntryEncoder.size(logEntry);
        LogId logId = logEntry.getId();
        return SegmentPayload.fixedOverheadSize() + VarlenEncoder.sizeInBytes(logId.getIndex()) + VarlenEncoder.sizeInBytes(logId.getTerm()) + entrySize;
    }

    static int fixedOverheadSize() {
        return 16;
    }
}

