/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.raft.storage.segstore.ReadModeIndexMemTable;
import org.apache.ignite.internal.raft.storage.segstore.SegmentInfo;
import org.apache.ignite.internal.raft.storage.segstore.WriteModeIndexMemTable;
import org.apache.ignite.internal.util.IgniteUtils;

class IndexMemTable
implements WriteModeIndexMemTable,
ReadModeIndexMemTable {
    private final Stripe[] stripes;

    IndexMemTable(int stripes) {
        this.stripes = new Stripe[stripes];
        for (int i = 0; i < stripes; ++i) {
            this.stripes[i] = new Stripe();
        }
    }

    @Override
    public void appendSegmentFileOffset(long groupId, long logIndex, int segmentFileOffset) {
        assert (segmentFileOffset != 0) : String.format("Segment file offset must not be 0 [groupId=%d]", groupId);
        ConcurrentMap<Long, SegmentInfo> memTable = this.memtable(groupId);
        SegmentInfo segmentInfo = (SegmentInfo)memTable.get(groupId);
        if (segmentInfo == null) {
            segmentInfo = new SegmentInfo(logIndex);
            segmentInfo.addOffset(logIndex, segmentFileOffset);
            memTable.put(groupId, segmentInfo);
        } else if (segmentInfo.isPrefixTombstone()) {
            segmentInfo = new SegmentInfo(logIndex, segmentInfo.firstIndexKept());
            segmentInfo.addOffset(logIndex, segmentFileOffset);
            memTable.put(groupId, segmentInfo);
        } else {
            segmentInfo.addOffset(logIndex, segmentFileOffset);
        }
    }

    @Override
    public SegmentInfo segmentInfo(long groupId) {
        return (SegmentInfo)this.memtable(groupId).get(groupId);
    }

    @Override
    public void truncateSuffix(long groupId, long lastLogIndexKept) {
        ConcurrentMap<Long, SegmentInfo> memtable = this.memtable(groupId);
        memtable.compute(groupId, (id, segmentInfo) -> {
            if (segmentInfo == null || lastLogIndexKept < segmentInfo.firstLogIndexInclusive()) {
                return new SegmentInfo(lastLogIndexKept + 1L);
            }
            if (segmentInfo.isPrefixTombstone()) {
                return new SegmentInfo(lastLogIndexKept + 1L, segmentInfo.firstIndexKept());
            }
            return segmentInfo.truncateSuffix(lastLogIndexKept);
        });
    }

    @Override
    public void truncatePrefix(long groupId, long firstIndexKept) {
        ConcurrentMap<Long, SegmentInfo> memtable = this.memtable(groupId);
        memtable.compute(groupId, (id, segmentInfo) -> {
            if (segmentInfo == null) {
                return SegmentInfo.prefixTombstone(firstIndexKept);
            }
            return segmentInfo.truncatePrefix(firstIndexKept);
        });
    }

    @Override
    public void reset(long groupId, long nextLogIndex) {
        ConcurrentMap<Long, SegmentInfo> memtable = this.memtable(groupId);
        memtable.compute(groupId, (id, segmentInfo) -> {
            if (segmentInfo == null || segmentInfo.isPrefixTombstone() || nextLogIndex < segmentInfo.firstLogIndexInclusive()) {
                return SegmentInfo.resetTombstone(nextLogIndex);
            }
            return segmentInfo.reset(nextLogIndex);
        });
    }

    @Override
    public ReadModeIndexMemTable transitionToReadMode() {
        return this;
    }

    @Override
    public int numGroups() {
        int result = 0;
        for (Stripe stripe : this.stripes) {
            result += stripe.memTable.size();
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Long, SegmentInfo>> iterator() {
        return new SegmentInfoIterator();
    }

    private Stripe stripe(long groupId) {
        int stripeIndex = IgniteUtils.safeAbs((int)(Long.hashCode(groupId) % this.stripes.length));
        return this.stripes[stripeIndex];
    }

    private ConcurrentMap<Long, SegmentInfo> memtable(long groupId) {
        return this.stripe((long)groupId).memTable;
    }

    private static class Stripe {
        private final ConcurrentMap<Long, SegmentInfo> memTable = new ConcurrentHashMap<Long, SegmentInfo>();

        private Stripe() {
        }
    }

    private class SegmentInfoIterator
    implements Iterator<Map.Entry<Long, SegmentInfo>> {
        private int stripeIndex = 0;
        private Iterator<Map.Entry<Long, SegmentInfo>> mapIterator = this.refreshIterator();

        private SegmentInfoIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.mapIterator.hasNext()) {
                return true;
            }
            if (this.stripeIndex < IndexMemTable.this.stripes.length) {
                this.mapIterator = this.refreshIterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public Map.Entry<Long, SegmentInfo> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.mapIterator.next();
        }

        private Iterator<Map.Entry<Long, SegmentInfo>> refreshIterator() {
            Stripe nextStripe = IndexMemTable.this.stripes[this.stripeIndex++];
            return nextStripe.memTable.entrySet().iterator();
        }
    }
}

