/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.client;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.raft.jraft.util.Utils;
import org.jetbrains.annotations.Nullable;

class RetryContext {
    private static final int MAX_RETRY_REASONS = 25;
    private final String groupId;
    private Peer targetPeer;
    private final Supplier<@Nullable String> originDescription;
    private final Function<Peer, ? extends NetworkMessage> requestFactory;
    private NetworkMessage request;
    private final long stopTime;
    private int retryCount = 0;
    private final Set<Peer> unavailablePeers = new HashSet<Peer>();
    private final List<RetryReason> retryReasons = new LinkedList<RetryReason>();
    @Nullable
    private UUID errorTraceId;
    private final long startTime;
    private long attemptScheduleTime;
    private long attemptStartTime;
    private final long responseTimeoutMillis;

    RetryContext(String groupId, Peer targetPeer, Supplier<@Nullable String> originDescription, Function<Peer, ? extends NetworkMessage> requestFactory, long sendWithRetryTimeoutMillis, long responseTimeoutMillis) {
        this.groupId = groupId;
        this.targetPeer = targetPeer;
        this.originDescription = originDescription;
        this.requestFactory = requestFactory;
        this.request = requestFactory.apply(targetPeer);
        this.stopTime = Utils.monotonicMsAfter(sendWithRetryTimeoutMillis);
        this.attemptScheduleTime = this.startTime = Utils.monotonicMs();
        this.attemptStartTime = this.startTime;
        this.responseTimeoutMillis = responseTimeoutMillis;
    }

    Peer targetPeer() {
        return this.targetPeer;
    }

    NetworkMessage request() {
        return this.request;
    }

    @Nullable
    String originCommandDescription() {
        return this.originDescription.get();
    }

    long stopTime() {
        return this.stopTime;
    }

    Set<Peer> unavailablePeers() {
        return this.unavailablePeers;
    }

    UUID errorTraceId() {
        if (this.errorTraceId == null) {
            this.errorTraceId = UUID.randomUUID();
        }
        return this.errorTraceId;
    }

    void resetUnavailablePeers() {
        this.unavailablePeers.clear();
    }

    RetryContext nextAttempt(Peer newTargetPeer, String shortReasonMessage) {
        long currentTime = Utils.monotonicMs();
        long currentWallClockTime = System.currentTimeMillis();
        String reasonMessage = shortReasonMessage + "; attemptWaitDuration=" + (this.attemptStartTime - this.attemptScheduleTime) + ", attemptDuration=" + (currentTime - this.attemptStartTime) + ", attemptStartTime=" + RetryContext.timestampToString(currentWallClockTime);
        this.retryReasons.add(new RetryReason(reasonMessage, currentWallClockTime));
        this.attemptScheduleTime = currentTime;
        if (this.retryReasons.size() > 25) {
            this.retryReasons.remove(0);
        }
        this.request = this.requestFactory.apply(newTargetPeer);
        this.targetPeer = newTargetPeer;
        ++this.retryCount;
        return this;
    }

    private static String timestampToString(long timestamp) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss,SSS").withZone(ZoneId.systemDefault());
        Instant instant = Instant.ofEpochMilli(timestamp);
        return formatter.format(instant);
    }

    RetryContext nextAttemptForUnavailablePeer(Peer newTargetPeer, String shortReasonMessage) {
        this.unavailablePeers.add(this.targetPeer);
        return this.nextAttempt(newTargetPeer, shortReasonMessage);
    }

    TimeoutException createTimeoutException() {
        long currentTime = Utils.monotonicMs();
        return new TimeoutException(IgniteStringFormatter.format((String)"Send with retry timed out [retryCount = {}, groupId = {}, traceId = {}, request = {}, originCommand = {}, retryReasons = {}, stopTime = {}, currentTime = {}, startTime = {}, duration = {}, currentWallTime = {}].", (Object[])new Object[]{this.retryCount, this.groupId, this.errorTraceId, this.request.toStringForLightLogging(), this.originDescription.get(), this.retryReasons.toString(), this.stopTime, currentTime, this.startTime, currentTime - this.startTime, System.currentTimeMillis()}));
    }

    void onNewAttempt() {
        this.attemptStartTime = Utils.monotonicMs();
    }

    long responseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    private static class RetryReason {
        final long timestamp;
        final String reason;

        RetryReason(String reason, long currentTime) {
            this.timestamp = currentTime;
            this.reason = reason;
        }

        public String toString() {
            return "[time=" + this.timestamp + ", msg=" + this.reason + "]";
        }
    }
}

