/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class AddPeerRequestProcessor
extends BaseCliRequestProcessor<CliRequests.AddPeerRequest> {
    public AddPeerRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.AddPeerRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.AddPeerRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.AddPeerRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldPeers = ctx.node.listPeers();
        PeerId addingPeer = new PeerId();
        String addingPeerIdStr = request.peerId();
        if (addingPeer.parse(addingPeerIdStr)) {
            assert (request.sequenceToken() != null) : "Sequence token is null";
        } else {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", addingPeerIdStr);
        }
        long sequenceToken = request.sequenceToken();
        LOG.info("Receive AddPeerRequest to {} from {}, adding {}", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), addingPeerIdStr});
        ctx.node.addPeer(addingPeer, sequenceToken, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                ArrayList<String> oldPeersList = new ArrayList<String>();
                ArrayList<String> newPeersList = new ArrayList<String>();
                boolean alreadyExists = false;
                for (PeerId oldPeer : oldPeers) {
                    oldPeersList.add(oldPeer.toString());
                    newPeersList.add(oldPeer.toString());
                    if (!oldPeer.equals(addingPeer)) continue;
                    alreadyExists = true;
                }
                if (!alreadyExists) {
                    newPeersList.add(addingPeerIdStr);
                }
                CliRequests.AddPeerResponse req = this.msgFactory().addPeerResponse().newPeersList(newPeersList).oldPeersList(oldPeersList).build();
                done.sendResponse(req);
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.AddPeerRequest.class.getName();
    }
}

