/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.ResetLearnersRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.ResetLearnersRequestSerializer;

public class ResetLearnersRequestImpl
implements CliRequests.ResetLearnersRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1015;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final Collection<String> learnersList;
    @IgniteToStringInclude
    private final Long sequenceToken;

    private ResetLearnersRequestImpl(String groupId, String leaderId, Collection<String> learnersList, Long sequenceToken) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.learnersList = learnersList;
        this.sequenceToken = sequenceToken;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public Collection<String> learnersList() {
        return this.learnersList;
    }

    @Override
    public Long sequenceToken() {
        return this.sequenceToken;
    }

    public MessageSerializer serializer() {
        return ResetLearnersRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ResetLearnersRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1015;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResetLearnersRequestImpl otherMessage = (ResetLearnersRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.learnersList, otherMessage.learnersList) && Objects.equals(this.sequenceToken, otherMessage.sequenceToken);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.leaderId, this.learnersList, this.sequenceToken);
        return result;
    }

    public ResetLearnersRequestImpl clone() {
        try {
            return (ResetLearnersRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ResetLearnersRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ResetLearnersRequestBuilder {
        private String groupId;
        private String leaderId;
        private Collection<String> learnersList;
        private Long sequenceToken;

        private Builder() {
        }

        @Override
        public ResetLearnersRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ResetLearnersRequestBuilder leaderId(String leaderId) {
            Objects.requireNonNull(leaderId, "leaderId is not marked @Nullable");
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public ResetLearnersRequestBuilder learnersList(Collection<String> learnersList) {
            Objects.requireNonNull(learnersList, "learnersList is not marked @Nullable");
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public ResetLearnersRequestBuilder sequenceToken(Long sequenceToken) {
            Objects.requireNonNull(sequenceToken, "sequenceToken is not marked @Nullable");
            this.sequenceToken = sequenceToken;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public Long sequenceToken() {
            return this.sequenceToken;
        }

        @Override
        public CliRequests.ResetLearnersRequest build() {
            return new ResetLearnersRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.leaderId, "leaderId is not marked @Nullable"), Objects.requireNonNull(this.learnersList, "learnersList is not marked @Nullable"), Objects.requireNonNull(this.sequenceToken, "sequenceToken is not marked @Nullable"));
        }

        @Override
        public CliRequests.ResetLearnersRequest buildDeserialized() {
            return new ResetLearnersRequestImpl(this.groupId, this.leaderId, this.learnersList, this.sequenceToken);
        }
    }
}

