/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.AppendEntriesResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class AppendEntriesResponseDeserializer
implements MessageDeserializer<RpcRequests.AppendEntriesResponse> {
    private final AppendEntriesResponseBuilder msg;

    AppendEntriesResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.appendEntriesResponse();
    }

    public Class<RpcRequests.AppendEntriesResponse> klass() {
        return RpcRequests.AppendEntriesResponse.class;
    }

    public RpcRequests.AppendEntriesResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.appendEntriesResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("errorCode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.errorCode(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("errorMsg");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.errorMsg(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("lastLogIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastLogIndex(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("leaderId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.leaderId((String)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readBoxedLong("maxObservableSafeTimeViolatedValue");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.maxObservableSafeTimeViolatedValue((Long)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                boolean tmp = reader.readBoolean("success");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.success(tmp);
                reader.incrementState();
            }
            case 6: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
            case 7: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.AppendEntriesResponse.class);
    }
}

