/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileMeta;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileMetaArray;
import org.jetbrains.annotations.Nullable;

class GroupIndexMeta {
    private final Deque<IndexMetaArrayHolder> fileMetaDeque = new ConcurrentLinkedDeque<IndexMetaArrayHolder>();

    GroupIndexMeta(IndexFileMeta startFileMeta) {
        this.fileMetaDeque.add(new IndexMetaArrayHolder(startFileMeta));
    }

    void addIndexMeta(IndexFileMeta indexFileMeta) {
        IndexMetaArrayHolder curFileMetas = this.fileMetaDeque.getLast();
        long curLastLogIndex = curFileMetas.lastLogIndexExclusive();
        long newFirstLogIndex = indexFileMeta.firstLogIndexInclusive();
        assert (newFirstLogIndex <= curLastLogIndex) : String.format("Gaps between Index File Metas are not allowed. Last log index: %d, new log index: %d", curLastLogIndex, newFirstLogIndex);
        if (curLastLogIndex == newFirstLogIndex) {
            curFileMetas.addIndexMeta(indexFileMeta);
        } else {
            this.fileMetaDeque.add(new IndexMetaArrayHolder(indexFileMeta));
        }
    }

    @Nullable
    IndexFileMeta indexMeta(long logIndex) {
        Iterator<IndexMetaArrayHolder> it = this.fileMetaDeque.descendingIterator();
        while (it.hasNext()) {
            IndexFileMeta indexMeta;
            IndexFileMetaArray fileMetas = it.next().fileMetas;
            if (logIndex >= fileMetas.lastLogIndexExclusive()) {
                return null;
            }
            if (logIndex < fileMetas.firstLogIndexInclusive() || (indexMeta = fileMetas.find(logIndex)) == null) continue;
            return indexMeta;
        }
        return null;
    }

    void truncatePrefix(long firstLogIndexKept) {
        IndexMetaArrayHolder holder;
        long firstLogIndex;
        Iterator<IndexMetaArrayHolder> it = this.fileMetaDeque.descendingIterator();
        while (it.hasNext() && (firstLogIndex = (holder = it.next()).firstLogIndexInclusive()) != firstLogIndexKept) {
            if (firstLogIndex >= firstLogIndexKept) continue;
            if (holder.lastLogIndexExclusive() <= firstLogIndexKept) {
                it.remove();
                break;
            }
            holder.truncateIndicesSmallerThan(firstLogIndexKept);
            break;
        }
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    long firstLogIndexInclusive() {
        for (IndexMetaArrayHolder indexMetaArrayHolder : this.fileMetaDeque) {
            long firstLogIndex = indexMetaArrayHolder.firstLogIndexInclusive();
            if (firstLogIndex < 0L) continue;
            return firstLogIndex;
        }
        return -1L;
    }

    long lastLogIndexExclusive() {
        return this.fileMetaDeque.getLast().lastLogIndexExclusive();
    }

    private static class IndexMetaArrayHolder {
        private static final VarHandle FILE_METAS_VH;
        volatile IndexFileMetaArray fileMetas;

        IndexMetaArrayHolder(IndexFileMeta startFileMeta) {
            this.fileMetas = new IndexFileMetaArray(startFileMeta);
        }

        void addIndexMeta(IndexFileMeta indexFileMeta) {
            IndexFileMetaArray fileMetas = this.fileMetas;
            this.setFileMetas(fileMetas, fileMetas.add(indexFileMeta));
        }

        long firstLogIndexInclusive() {
            return this.fileMetas.firstLogIndexInclusive();
        }

        long lastLogIndexExclusive() {
            return this.fileMetas.lastLogIndexExclusive();
        }

        void truncateIndicesSmallerThan(long firstLogIndexKept) {
            IndexFileMetaArray fileMetas = this.fileMetas;
            this.setFileMetas(fileMetas, fileMetas.truncateIndicesSmallerThan(firstLogIndexKept));
        }

        private void setFileMetas(IndexFileMetaArray fileMetas, IndexFileMetaArray newFileMetas) {
            boolean updated = FILE_METAS_VH.compareAndSet(this, fileMetas, newFileMetas);
            assert (updated) : "Concurrent writes detected";
        }

        static {
            try {
                FILE_METAS_VH = MethodHandles.lookup().findVarHandle(IndexMetaArrayHolder.class, "fileMetas", IndexFileMetaArray.class);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

