/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.ignite.internal.raft.storage.impl.DefaultLogStorageFactory;
import org.apache.ignite.internal.rocksdb.EncryptionPluginUtils;
import org.gridgain.internal.encryption.EncryptionManager;
import org.jetbrains.annotations.TestOnly;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.GgEncryptionEnv;

public class EncryptedLogStorageFactory
extends DefaultLogStorageFactory {
    private final Supplier<EncryptionManager> encryptionManager;

    @TestOnly
    public EncryptedLogStorageFactory(String nodeName, Path path, Supplier<EncryptionManager> encryptionManager) {
        this("test", nodeName, path, encryptionManager, true);
    }

    public EncryptedLogStorageFactory(String factoryName, String nodeName, Path path, Supplier<EncryptionManager> encryptionManager, boolean fsync) {
        super(factoryName, nodeName, path, fsync);
        this.encryptionManager = encryptionManager;
    }

    @Override
    protected DBOptions createDbOptions() {
        int currResources;
        DBOptions dbOptions = super.createDbOptions();
        EncryptionManager em = this.encryptionManager.get();
        GgEncryptionEnv env = EncryptionPluginUtils.createDbOptionsEnvironment((EncryptionManager)em, arg_0 -> this.lambda$createDbOptions$0(currResources = this.additionalDbClosables.size(), arg_0));
        if (env != null) {
            dbOptions.setEnv((Env)env);
        }
        return dbOptions;
    }

    private /* synthetic */ void lambda$createDbOptions$0(int currResources, AbstractNativeReference res) {
        this.additionalDbClosables.add(currResources, res);
    }
}

