/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class ResetLearnersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ResetLearnersRequest> {
    public ResetLearnersRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.ResetLearnersRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.ResetLearnersRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ResetLearnersRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldLearners = ctx.node.listLearners();
        ArrayList<PeerId> newLearners = new ArrayList<PeerId>(request.learnersList().size());
        Iterator<String> iterator = request.learnersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerStr = iterator.next();
            if (!peer.parse(peerStr)) {
                return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerStr);
            }
            newLearners.add(peer);
        }
        assert (request.sequenceToken() != null) : "Sequence token is null";
        long sequenceToken = request.sequenceToken();
        LOG.info("Receive ResetLearnersRequest to {} from {}, resetting into {}.", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), newLearners});
        ctx.node.resetLearners(newLearners, sequenceToken, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.LearnersOpResponse response = this.msgFactory().learnersOpResponse().oldLearnersList(oldLearners.stream().map(Object::toString).collect(Collectors.toList())).newLearnersList(newLearners.stream().map(Object::toString).collect(Collectors.toList())).build();
                done.sendResponse(response);
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.ResetLearnersRequest.class.getName();
    }
}

