/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.GetLeaderResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.GetLeaderResponseSerializer;

public class GetLeaderResponseImpl
implements CliRequests.GetLeaderResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1010;
    @IgniteToStringInclude
    private final long currentTerm;
    @IgniteToStringInclude
    private final String leaderId;

    private GetLeaderResponseImpl(long currentTerm, String leaderId) {
        this.currentTerm = currentTerm;
        this.leaderId = leaderId;
    }

    @Override
    public long currentTerm() {
        return this.currentTerm;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    public MessageSerializer serializer() {
        return GetLeaderResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(GetLeaderResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1010;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetLeaderResponseImpl otherMessage = (GetLeaderResponseImpl)other;
        return Objects.equals(this.leaderId, otherMessage.leaderId) && this.currentTerm == otherMessage.currentTerm;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.currentTerm, this.leaderId);
        return result;
    }

    public GetLeaderResponseImpl clone() {
        try {
            return (GetLeaderResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetLeaderResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetLeaderResponseBuilder {
        private long currentTerm;
        private String leaderId;

        private Builder() {
        }

        @Override
        public GetLeaderResponseBuilder currentTerm(long currentTerm) {
            this.currentTerm = currentTerm;
            return this;
        }

        @Override
        public GetLeaderResponseBuilder leaderId(String leaderId) {
            Objects.requireNonNull(leaderId, "leaderId is not marked @Nullable");
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public long currentTerm() {
            return this.currentTerm;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public CliRequests.GetLeaderResponse build() {
            return new GetLeaderResponseImpl(this.currentTerm, Objects.requireNonNull(this.leaderId, "leaderId is not marked @Nullable"));
        }

        @Override
        public CliRequests.GetLeaderResponse buildDeserialized() {
            return new GetLeaderResponseImpl(this.currentTerm, this.leaderId);
        }
    }
}

