/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Iterator;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.raft.storage.segstore.CheckpointQueue;
import org.apache.ignite.internal.raft.storage.segstore.EntrySearchResult;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileManager;
import org.apache.ignite.internal.raft.storage.segstore.ReadModeIndexMemTable;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFile;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFileManager;
import org.apache.ignite.internal.raft.storage.segstore.SegmentInfo;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;

class RaftLogCheckpointer {
    static final int MAX_QUEUE_SIZE = 10;
    private final CheckpointQueue queue = new CheckpointQueue(10);
    private final Thread checkpointThread;
    private final IndexFileManager indexFileManager;
    private final FailureProcessor failureProcessor;

    RaftLogCheckpointer(String nodeName, IndexFileManager indexFileManager, FailureProcessor failureProcessor) {
        this.indexFileManager = indexFileManager;
        this.failureProcessor = failureProcessor;
        this.checkpointThread = new IgniteThread(nodeName, "segstore-checkpoint", (Runnable)new CheckpointTask(), new ThreadOperation[0]);
    }

    void start() {
        this.checkpointThread.start();
    }

    void stop() throws Exception {
        IgniteUtils.closeAllManually((ManuallyCloseable[])new ManuallyCloseable[]{this::stopCheckpointThread, this.queue});
    }

    private void stopCheckpointThread() {
        this.checkpointThread.interrupt();
        try {
            this.checkpointThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Marshalling.COMMON_ERR, "Interrupted while waiting for the checkpoint thread to finish.", (Throwable)e);
        }
    }

    void onRollover(SegmentFile segmentFile, ReadModeIndexMemTable indexMemTable) {
        try {
            this.queue.add(segmentFile, indexMemTable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Marshalling.COMMON_ERR, "Interrupted while adding an entry to the checkpoint queue.", (Throwable)e);
        }
    }

    EntrySearchResult findSegmentPayloadInQueue(long groupId, long logIndex) {
        Iterator<CheckpointQueue.Entry> it = this.queue.tailIterator();
        while (it.hasNext()) {
            CheckpointQueue.Entry e = it.next();
            SegmentInfo segmentInfo = e.memTable().segmentInfo(groupId);
            if (segmentInfo == null) continue;
            if (logIndex >= segmentInfo.lastLogIndexExclusive()) {
                return EntrySearchResult.notFound();
            }
            if (logIndex < segmentInfo.firstIndexKept()) {
                return EntrySearchResult.notFound();
            }
            int segmentPayloadOffset = segmentInfo.getOffset(logIndex);
            if (segmentPayloadOffset == SegmentInfo.MISSING_SEGMENT_FILE_OFFSET) continue;
            ByteBuffer entryBuffer = e.segmentFile().buffer().position(segmentPayloadOffset);
            return EntrySearchResult.success(entryBuffer);
        }
        return EntrySearchResult.continueSearch();
    }

    private class CheckpointTask
    implements Runnable {
        private CheckpointTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CheckpointQueue.Entry entry = RaftLogCheckpointer.this.queue.peekHead();
                        SegmentFile segmentFile = entry.segmentFile();
                        segmentFile.closeForRollover(SegmentFileManager.SWITCH_SEGMENT_RECORD);
                        segmentFile.sync();
                        RaftLogCheckpointer.this.indexFileManager.saveIndexMemtable(entry.memTable());
                        RaftLogCheckpointer.this.queue.removeHead();
                    }
                }
                catch (InterruptedException | ClosedByInterruptException e) {
                    return;
                }
                catch (IOException e) {
                    RaftLogCheckpointer.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
                    continue;
                }
                break;
            }
        }
    }
}

