/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.logit.storage.file.segment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.codec.DefaultLogEntryCodecFactory;
import org.apache.ignite.raft.jraft.entity.codec.v1.V1Encoder;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.AbstractFile;
import org.apache.ignite.raft.jraft.util.Bits;

public class SegmentFile
extends AbstractFile {
    private static final IgniteLogger LOG = Loggers.forClass(SegmentFile.class);
    public static final byte[] RECORD_MAGIC_BYTES = new byte[]{87, -118};
    public static final int RECORD_MAGIC_BYTES_SIZE = RECORD_MAGIC_BYTES.length;
    private static final int RECORD_DATA_LENGTH_SIZE = 4;

    public SegmentFile(RaftOptions raftOptions, String filePath, int fileSize) {
        super(raftOptions, filePath, fileSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendData(long logIndex, byte[] data) {
        this.writeLock.lock();
        try {
            assert (logIndex > this.getLastLogIndex());
            int n = this.doAppend(logIndex, addr -> {
                GridUnsafe.putByte((long)addr, (byte)RECORD_MAGIC_BYTES[0]);
                GridUnsafe.putByte((long)(addr + 1L), (byte)RECORD_MAGIC_BYTES[1]);
                Bits.putIntLittleEndian(addr + 2L, data.length);
                GridUnsafe.copyHeapOffheap((Object)data, (long)GridUnsafe.BYTE_ARR_OFF, (long)(addr + 6L), (long)data.length);
                return SegmentFile.getWriteBytes(data);
            });
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendData(long logIndex, V1Encoder encoder, LogEntry entry, int entrySize) {
        this.writeLock.lock();
        try {
            assert (logIndex > this.getLastLogIndex());
            int n = this.doAppend(logIndex, addr -> {
                GridUnsafe.putByte((long)addr, (byte)RECORD_MAGIC_BYTES[0]);
                GridUnsafe.putByte((long)(addr + 1L), (byte)RECORD_MAGIC_BYTES[1]);
                Bits.putIntLittleEndian(addr + 2L, entrySize);
                encoder.append(addr + 6L, entry);
                return entrySize + 6;
            });
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] lookupData(long logIndex, int pos) {
        assert (pos >= this.header.getHeaderSize());
        this.mapInIfNecessary();
        this.readLock.lock();
        try {
            if (logIndex < this.header.getFirstLogIndex() || logIndex > this.getLastLogIndex()) {
                LOG.warn("Try to read data from segment file {} out of range, logIndex={}, readPos={}, firstLogIndex={}, lastLogIndex={}.", new Object[]{this.getFilePath(), logIndex, pos, this.header.getFirstLogIndex(), this.getLastLogIndex()});
                byte[] byArray = null;
                return byArray;
            }
            if (pos > this.getWrotePosition()) {
                LOG.warn("Try to read data from segment file {} out of written position, logIndex={}, readPos={}, wrotePos={}, flushPos={}.", new Object[]{this.getFilePath(), logIndex, pos, this.getWrotePosition(), this.getFlushedPosition()});
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.lookupData(pos);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] lookupData(int pos) {
        assert (pos >= this.header.getHeaderSize());
        this.mapInIfNecessary();
        this.readLock.lock();
        try {
            ByteBuffer readBuffer = this.sliceByteBuffer();
            readBuffer.position(pos);
            if (readBuffer.remaining() < RECORD_MAGIC_BYTES_SIZE) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] magic = new byte[RECORD_MAGIC_BYTES_SIZE];
            readBuffer.get(magic);
            if (!Arrays.equals(magic, RECORD_MAGIC_BYTES)) {
                byte[] byArray = null;
                return byArray;
            }
            int dataLen = readBuffer.getInt();
            if (dataLen <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] data = new byte[dataLen];
            readBuffer.get(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public AbstractFile.CheckDataResult checkData(ByteBuffer buffer) {
        assert (buffer.order() == LOGIT_BYTE_ORDER);
        if (buffer.remaining() < RECORD_MAGIC_BYTES_SIZE) {
            return AbstractFile.CheckDataResult.CHECK_FAIL;
        }
        byte[] magic = new byte[RECORD_MAGIC_BYTES_SIZE];
        buffer.get(magic);
        if (!Arrays.equals(magic, RECORD_MAGIC_BYTES)) {
            return AbstractFile.CheckDataResult.FILE_END;
        }
        if (buffer.remaining() < 4) {
            return AbstractFile.CheckDataResult.CHECK_FAIL;
        }
        int dataLen = buffer.getInt();
        if (buffer.remaining() < dataLen) {
            return AbstractFile.CheckDataResult.CHECK_FAIL;
        }
        return new AbstractFile.CheckDataResult(RECORD_MAGIC_BYTES_SIZE + 4 + dataLen);
    }

    @Override
    public void onRecoverDone(int recoverPosition) {
        LogEntry lastEntry;
        ByteBuffer buffer = this.sliceByteBuffer();
        buffer.position(recoverPosition);
        byte[] data = this.lookupData(recoverPosition);
        if (data != null && (lastEntry = DefaultLogEntryCodecFactory.getInstance().decoder().decode(data)) != null) {
            this.setLastLogIndex(lastEntry.getId().getIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int truncate(long logIndex, int pos) {
        this.writeLock.lock();
        try {
            if (logIndex < this.header.getFirstLogIndex() || logIndex > this.header.getLastLogIndex()) {
                int n = 0;
                return n;
            }
            if (pos < 0) {
                int n = this.getWrotePosition();
                return n;
            }
            this.updateAllPosition(pos);
            this.clear(this.getWrotePosition());
            this.header.setLastLogIndex(logIndex - 1L);
            int n = pos;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static int getWriteBytes(byte[] data) {
        return SegmentFile.getWriteBytes(data.length);
    }

    public static int getWriteBytes(int dataSize) {
        return RECORD_MAGIC_BYTES_SIZE + 4 + dataSize;
    }
}

