/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class AddLearnersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.AddLearnersRequest> {
    public AddLearnersRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.AddLearnersRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.AddLearnersRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.AddLearnersRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldLearners = ctx.node.listLearners();
        ArrayList<PeerId> addingLearners = new ArrayList<PeerId>();
        Iterator<String> iterator = request.learnersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerStr = iterator.next();
            if (!peer.parse(peerStr)) {
                return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerStr);
            }
            addingLearners.add(peer);
        }
        assert (request.sequenceToken() != null) : "Sequence token is null";
        long sequenceToken = request.sequenceToken();
        LOG.info("Receive AddLearnersRequest to {} from {}, adding {}.", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), addingLearners});
        ctx.node.addLearners(addingLearners, sequenceToken, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                ArrayList<String> oldLearnersList = new ArrayList<String>();
                ArrayList<String> newLearnersList = new ArrayList<String>();
                for (PeerId peer : oldLearners) {
                    oldLearnersList.add(peer.toString());
                    newLearnersList.add(peer.toString());
                }
                for (PeerId peer : addingLearners) {
                    if (oldLearners.contains(peer)) continue;
                    newLearnersList.add(peer.toString());
                }
                CliRequests.LearnersOpResponse req = this.msgFactory().learnersOpResponse().oldLearnersList(oldLearnersList).newLearnersList(newLearnersList).build();
                done.sendResponse(req);
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.AddLearnersRequest.class.getName();
    }
}

