/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.GetFileResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class GetFileResponseDeserializer
implements MessageDeserializer<RpcRequests.GetFileResponse> {
    private final GetFileResponseBuilder msg;

    GetFileResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.getFileResponse();
    }

    public Class<RpcRequests.GetFileResponse> klass() {
        return RpcRequests.GetFileResponse.class;
    }

    public RpcRequests.GetFileResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.getFileResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("data");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.data(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                boolean tmp = reader.readBoolean("eof");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.eof(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("readSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.readSize(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.GetFileResponse.class);
    }
}

