/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.ErrorResponseImpl;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class ErrorResponseSerializer
implements MessageSerializer<RpcRequests.ErrorResponse> {
    public static final ErrorResponseSerializer INSTANCE = new ErrorResponseSerializer();

    private ErrorResponseSerializer() {
    }

    public boolean writeMessage(RpcRequests.ErrorResponse msg, MessageWriter writer) throws MessageMappingException {
        ErrorResponseImpl message = (ErrorResponseImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.errorResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("errorCode", message.errorCode());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("errorMsg", message.errorMsg());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("leaderId", message.leaderId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoxedLong("maxObservableSafeTimeViolatedValue", message.maxObservableSafeTimeViolatedValue());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

