/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.CliService;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.JRaftException;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.option.CliOptions;
import org.apache.ignite.raft.jraft.rpc.CliClientService;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.impl.cli.CliClientServiceImpl;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.StringUtils;
import org.apache.ignite.raft.jraft.util.Utils;

public class CliServiceImpl
implements CliService {
    private static final IgniteLogger LOG = Loggers.forClass(CliServiceImpl.class);
    private CliOptions cliOptions;
    private CliClientService cliClientService;

    @Override
    public synchronized boolean init(CliOptions opts) {
        Requires.requireNonNull(opts, "Null cli options");
        if (this.cliClientService != null) {
            return true;
        }
        this.cliOptions = opts;
        this.cliClientService = new CliClientServiceImpl();
        return this.cliClientService.init(this.cliOptions);
    }

    @Override
    public synchronized void shutdown() {
        if (this.cliClientService == null) {
            return;
        }
        this.cliClientService.shutdown();
        this.cliClientService = null;
    }

    private void recordConfigurationChange(String groupId, Collection<String> oldPeersList, Collection<String> newPeersList) {
        Configuration oldConf = new Configuration();
        for (String peerIdStr : oldPeersList) {
            PeerId oldPeer = new PeerId();
            oldPeer.parse(peerIdStr);
            oldConf.addPeer(oldPeer);
        }
        Configuration newConf = new Configuration();
        for (String peerIdStr : newPeersList) {
            PeerId newPeer = new PeerId();
            newPeer.parse(peerIdStr);
            newConf.addPeer(newPeer);
        }
        LOG.info("Configuration of replication group {} changed from {} to {}.", new Object[]{groupId, oldConf, newConf});
    }

    private Status checkLeaderAndConnect(String groupId, Configuration conf, PeerId leaderId) {
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId)) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        return Status.OK();
    }

    @Override
    public Status addPeer(String groupId, Configuration conf, PeerId peer, long sequenceToken) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(peer, "Null peer");
        PeerId leaderId = new PeerId();
        Status st = this.checkLeaderAndConnect(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        CliRequests.AddPeerRequest req = this.cliOptions.getRaftMessagesFactory().addPeerRequest().groupId(groupId).leaderId(leaderId.toString()).peerId(peer.toString()).sequenceToken(sequenceToken).build();
        try {
            Message result = this.cliClientService.addPeer(leaderId, req, null).get();
            if (result instanceof CliRequests.AddPeerResponse) {
                CliRequests.AddPeerResponse resp = (CliRequests.AddPeerResponse)result;
                this.recordConfigurationChange(groupId, resp.oldPeersList(), resp.newPeersList());
                return Status.OK();
            }
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    private Status statusFromResponse(Message result) {
        RpcRequests.ErrorResponse resp = (RpcRequests.ErrorResponse)result;
        return new Status(resp.errorCode(), resp.errorMsg());
    }

    @Override
    public Status removePeer(String groupId, Configuration conf, PeerId peer, long sequenceToken) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(peer, "Null peer");
        Requires.requireTrue(!peer.isEmpty(), "Removing peer is blank");
        PeerId leaderId = new PeerId();
        Status st = this.checkLeaderAndConnect(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        CliRequests.RemovePeerRequest req = this.cliOptions.getRaftMessagesFactory().removePeerRequest().groupId(groupId).leaderId(leaderId.toString()).peerId(peer.toString()).sequenceToken(sequenceToken).build();
        try {
            Message result = this.cliClientService.removePeer(leaderId, req, null).get();
            if (result instanceof CliRequests.RemovePeerResponse) {
                CliRequests.RemovePeerResponse resp = (CliRequests.RemovePeerResponse)result;
                this.recordConfigurationChange(groupId, resp.oldPeersList(), resp.newPeersList());
                return Status.OK();
            }
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status changePeersAndLearners(String groupId, Configuration conf, Configuration newPeersAndLearners, long term, long sequenceToken) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(newPeersAndLearners, "Null new configuration");
        PeerId leaderId = new PeerId();
        Status st = this.checkLeaderAndConnect(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        CliRequests.ChangePeersAndLearnersRequest req = this.cliOptions.getRaftMessagesFactory().changePeersAndLearnersRequest().groupId(groupId).leaderId(leaderId.toString()).newPeersList(newPeersAndLearners.getPeers().stream().map(Object::toString).collect(Collectors.toList())).newLearnersList(newPeersAndLearners.getLearners().stream().map(Object::toString).collect(Collectors.toList())).term(term).sequenceToken(sequenceToken).build();
        try {
            Message result = this.cliClientService.changePeersAndLearners(leaderId, req, null).get();
            if (result instanceof CliRequests.ChangePeersAndLearnersResponse) {
                CliRequests.ChangePeersAndLearnersResponse resp = (CliRequests.ChangePeersAndLearnersResponse)result;
                this.recordConfigurationChange(groupId, resp.oldPeersList(), resp.newPeersList());
                return Status.OK();
            }
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status resetPeer(String groupId, PeerId peerId, Configuration newPeers, long sequenceToken) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(peerId, "Null peerId");
        Requires.requireNonNull(newPeers, "Null new peers");
        if (!this.cliClientService.connect(peerId)) {
            return new Status(-1, "Fail to init channel to %s", peerId);
        }
        CliRequests.ResetPeerRequest req = this.cliOptions.getRaftMessagesFactory().resetPeerRequest().groupId(groupId).peerId(peerId.toString()).newPeersList(newPeers.getPeers().stream().map(Object::toString).collect(Collectors.toList())).sequenceToken(sequenceToken).build();
        try {
            Message result = this.cliClientService.resetPeer(peerId, req, null).get();
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    private void checkPeers(Collection<PeerId> peers) {
        for (PeerId peer : peers) {
            Requires.requireNonNull(peer, "Null peer in collection");
        }
    }

    @Override
    public Status addLearners(String groupId, Configuration conf, List<PeerId> learners, long sequenceToken) {
        this.checkLearnersOpParams(groupId, conf, learners);
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId)) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        CliRequests.AddLearnersRequest rb = this.cliOptions.getRaftMessagesFactory().addLearnersRequest().groupId(groupId).leaderId(leaderId.toString()).learnersList(learners.stream().map(Object::toString).collect(Collectors.toList())).sequenceToken(sequenceToken).build();
        try {
            Message result = this.cliClientService.addLearners(leaderId, rb, null).get();
            return this.processLearnersOpResponse(groupId, result, "adding learners: %s", learners);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    private void checkLearnersOpParams(String groupId, Configuration conf, List<PeerId> learners) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireTrue(learners != null && !learners.isEmpty(), "Empty peers");
        this.checkPeers(learners);
    }

    private Status processLearnersOpResponse(String groupId, Message result, String fmt, Object ... formatArgs) {
        if (result instanceof CliRequests.LearnersOpResponse) {
            CliRequests.LearnersOpResponse resp = (CliRequests.LearnersOpResponse)result;
            Configuration oldConf = new Configuration();
            for (String peerIdStr : resp.oldLearnersList()) {
                PeerId oldPeer = new PeerId();
                oldPeer.parse(peerIdStr);
                oldConf.addLearner(oldPeer);
            }
            Configuration newConf = new Configuration();
            for (String peerIdStr : resp.newLearnersList()) {
                PeerId newPeer = new PeerId();
                newPeer.parse(peerIdStr);
                newConf.addLearner(newPeer);
            }
            LOG.info("Learners of replication group {} changed from {} to {} after {}.", new Object[]{groupId, oldConf, newConf, String.format(fmt, formatArgs)});
            return Status.OK();
        }
        return this.statusFromResponse(result);
    }

    @Override
    public Status removeLearners(String groupId, Configuration conf, List<PeerId> learners, long sequenceToken) {
        this.checkLearnersOpParams(groupId, conf, learners);
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId)) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        CliRequests.RemoveLearnersRequest req = this.cliOptions.getRaftMessagesFactory().removeLearnersRequest().groupId(groupId).leaderId(leaderId.toString()).learnersList(learners.stream().map(Object::toString).collect(Collectors.toList())).sequenceToken(sequenceToken).build();
        try {
            Message result = this.cliClientService.removeLearners(leaderId, req, null).get();
            return this.processLearnersOpResponse(groupId, result, "removing learners: %s", learners);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status learner2Follower(String groupId, Configuration conf, PeerId learner, long sequenceToken) {
        Status status = this.removeLearners(groupId, conf, Arrays.asList(learner), sequenceToken);
        if (status.isOk()) {
            status = this.addPeer(groupId, conf, new PeerId(learner.getConsistentId()), sequenceToken);
        }
        return status;
    }

    @Override
    public Status resetLearners(String groupId, Configuration conf, List<PeerId> learners, long sequenceToken) {
        this.checkLearnersOpParams(groupId, conf, learners);
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        if (!this.cliClientService.connect(leaderId)) {
            return new Status(-1, "Fail to init channel to leader %s", leaderId);
        }
        CliRequests.ResetLearnersRequest req = this.cliOptions.getRaftMessagesFactory().resetLearnersRequest().groupId(groupId).leaderId(leaderId.toString()).learnersList(learners.stream().map(Object::toString).collect(Collectors.toList())).sequenceToken(sequenceToken).build();
        try {
            Message result = this.cliClientService.resetLearners(leaderId, req, null).get();
            return this.processLearnersOpResponse(groupId, result, "resetting learners: %s", learners);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status transferLeader(String groupId, Configuration conf, PeerId peer) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireNonNull(peer, "Null peer");
        PeerId leaderId = new PeerId();
        Status st = this.checkLeaderAndConnect(groupId, conf, leaderId);
        if (!st.isOk()) {
            return st;
        }
        CliRequests.TransferLeaderRequest rb = this.cliOptions.getRaftMessagesFactory().transferLeaderRequest().groupId(groupId).leaderId(leaderId.toString()).peerId(peer.isEmpty() ? null : peer.toString()).build();
        try {
            Message result = this.cliClientService.transferLeader(leaderId, rb, null).get();
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status snapshot(String groupId, PeerId peer, boolean forced) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(peer, "Null peer");
        if (!this.cliClientService.connect(peer)) {
            return new Status(-1, "Fail to init channel to %s", peer);
        }
        CliRequests.SnapshotRequest req = this.cliOptions.getRaftMessagesFactory().snapshotRequest().groupId(groupId).peerId(peer.toString()).forced(forced).build();
        try {
            Message result = this.cliClientService.snapshot(peer, req, null).get();
            return this.statusFromResponse(result);
        }
        catch (Exception e) {
            return new Status(-1, e.getMessage());
        }
    }

    @Override
    public Status getLeader(String groupId, Configuration conf, PeerId leaderId) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(leaderId, "Null leader id");
        if (conf == null || conf.isEmpty()) {
            return new Status(RaftError.EINVAL, "Empty group configuration", new Object[0]);
        }
        Status st = new Status(-1, "Fail to get leader of group %s", groupId);
        for (PeerId peer : conf) {
            String savedMsg;
            if (!this.cliClientService.connect(peer)) {
                LOG.error("Fail to connect peer {} to get leader for group {}.", new Object[]{peer, groupId});
                continue;
            }
            CliRequests.GetLeaderRequest rb = this.cliOptions.getRaftMessagesFactory().getLeaderRequest().groupId(groupId).peerId(peer.toString()).build();
            Future<Message> result = this.cliClientService.getLeader(peer, rb, null);
            try {
                Message msg = result.get(this.cliOptions.getTimeoutMs() <= 0 ? (long)this.cliOptions.getRpcDefaultTimeout() : (long)this.cliOptions.getTimeoutMs(), TimeUnit.MILLISECONDS);
                if (msg instanceof RpcRequests.ErrorResponse) {
                    if (st.isOk()) {
                        st.setError(-1, ((RpcRequests.ErrorResponse)msg).errorMsg(), new Object[0]);
                        continue;
                    }
                    savedMsg = st.getErrorMsg();
                    st.setError(-1, "%s, %s", savedMsg, ((RpcRequests.ErrorResponse)msg).errorMsg());
                    continue;
                }
                CliRequests.GetLeaderResponse response = (CliRequests.GetLeaderResponse)msg;
                if (!leaderId.parse(response.leaderId())) continue;
                break;
            }
            catch (Exception e) {
                if (st.isOk()) {
                    st.setError(-1, e.getMessage(), new Object[0]);
                    continue;
                }
                savedMsg = st.getErrorMsg();
                st.setError(-1, "%s, %s", savedMsg, e.getMessage());
            }
        }
        if (leaderId.isEmpty()) {
            return st;
        }
        return Status.OK();
    }

    @Override
    public List<PeerId> getPeers(String groupId, Configuration conf) {
        return this.getPeers(groupId, conf, false, false);
    }

    @Override
    public List<PeerId> getAlivePeers(String groupId, Configuration conf) {
        return this.getPeers(groupId, conf, false, true);
    }

    @Override
    public List<PeerId> getLearners(String groupId, Configuration conf) {
        return this.getPeers(groupId, conf, true, false);
    }

    @Override
    public List<PeerId> getAliveLearners(String groupId, Configuration conf) {
        return this.getPeers(groupId, conf, true, true);
    }

    @Override
    public Status rebalance(Set<String> balanceGroupIds, Configuration conf, Map<String, PeerId> rebalancedLeaderIds) {
        Status status;
        String groupId;
        Requires.requireNonNull(balanceGroupIds, "Null balance group ids");
        Requires.requireTrue(!balanceGroupIds.isEmpty(), "Empty balance group ids");
        Requires.requireNonNull(conf, "Null configuration");
        Requires.requireTrue(!conf.isEmpty(), "No peers of configuration");
        LOG.info("Rebalance start with raft groups={}.", new Object[]{balanceGroupIds});
        long start = Utils.monotonicMs();
        int transfers = 0;
        Status failedStatus = null;
        ArrayDeque<String> groupDeque = new ArrayDeque<String>(balanceGroupIds);
        LeaderCounter leaderCounter = new LeaderCounter(balanceGroupIds.size(), conf.size());
        while ((groupId = (String)groupDeque.poll()) != null) {
            PeerId targetPeer;
            PeerId leaderId = new PeerId();
            Status leaderStatus = this.getLeader(groupId, conf, leaderId);
            if (!leaderStatus.isOk()) {
                failedStatus = leaderStatus;
                break;
            }
            if (rebalancedLeaderIds != null) {
                rebalancedLeaderIds.put(groupId, leaderId);
            }
            if (leaderCounter.incrementAndGet(leaderId) <= leaderCounter.getExpectedAverage() || (targetPeer = this.findTargetPeer(leaderId, groupId, conf, leaderCounter)).isEmpty()) continue;
            Status transferStatus = this.transferLeader(groupId, conf, targetPeer);
            ++transfers;
            if (!transferStatus.isOk()) {
                failedStatus = transferStatus;
                break;
            }
            LOG.info("Group {} transfer leader to {}.", new Object[]{groupId, targetPeer});
            leaderCounter.decrementAndGet(leaderId);
            groupDeque.add(groupId);
            if (rebalancedLeaderIds == null) continue;
            rebalancedLeaderIds.put(groupId, targetPeer);
        }
        Status status2 = status = failedStatus != null ? failedStatus : Status.OK();
        if (LOG.isInfoEnabled()) {
            LOG.info("Rebalanced raft groups={}, status={}, number of transfers={}, elapsed time={} ms, rebalanced result={}.", new Object[]{balanceGroupIds, status, transfers, Utils.monotonicMs() - start, rebalancedLeaderIds});
        }
        return status;
    }

    private PeerId findTargetPeer(PeerId self, String groupId, Configuration conf, LeaderCounter leaderCounter) {
        for (PeerId peerId : this.getAlivePeers(groupId, conf)) {
            if (peerId.equals(self) || leaderCounter.get(peerId) >= leaderCounter.getExpectedAverage()) continue;
            return peerId;
        }
        return PeerId.emptyPeer();
    }

    private List<PeerId> getPeers(String groupId, Configuration conf, boolean returnLearners, boolean onlyGetAlive) {
        Requires.requireTrue(!StringUtils.isBlank(groupId), "Blank group id");
        Requires.requireNonNull(conf, "Null conf");
        PeerId leaderId = new PeerId();
        Status st = this.getLeader(groupId, conf, leaderId);
        if (!st.isOk()) {
            throw new IllegalStateException(st.getErrorMsg());
        }
        if (!this.cliClientService.connect(leaderId)) {
            throw new IllegalStateException("Fail to init channel to leader " + leaderId);
        }
        CliRequests.GetPeersRequest req = this.cliOptions.getRaftMessagesFactory().getPeersRequest().groupId(groupId).leaderId(leaderId.toString()).onlyAlive(onlyGetAlive).build();
        try {
            Message result = this.cliClientService.getPeers(leaderId, req, null).get(this.cliOptions.getTimeoutMs() <= 0 ? (long)this.cliOptions.getRpcDefaultTimeout() : (long)this.cliOptions.getTimeoutMs(), TimeUnit.MILLISECONDS);
            if (result instanceof CliRequests.GetPeersResponse) {
                CliRequests.GetPeersResponse resp = (CliRequests.GetPeersResponse)result;
                ArrayList<PeerId> peerIdList = new ArrayList<PeerId>();
                Collection<String> responsePeers = returnLearners ? resp.learnersList() : resp.peersList();
                for (String peerIdStr : responsePeers) {
                    PeerId newPeer = new PeerId();
                    newPeer.parse(peerIdStr);
                    peerIdList.add(newPeer);
                }
                return peerIdList;
            }
            RpcRequests.ErrorResponse resp = (RpcRequests.ErrorResponse)result;
            throw new JRaftException(resp.errorMsg());
        }
        catch (JRaftException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRaftException(e);
        }
    }

    public CliClientService getCliClientService() {
        return this.cliClientService;
    }

    private static class LeaderCounter {
        private final Map<PeerId, Integer> counter = new HashMap<PeerId, Integer>();
        private final int expectedAverage;

        LeaderCounter(int groupCount, int peerCount) {
            this.expectedAverage = (int)Math.ceil((double)groupCount / (double)peerCount);
        }

        public int getExpectedAverage() {
            return this.expectedAverage;
        }

        public int incrementAndGet(PeerId peerId) {
            return this.counter.compute(peerId, (ignored, num) -> num == null ? 1 : num + 1);
        }

        public int decrementAndGet(PeerId peerId) {
            return this.counter.compute(peerId, (ignored, num) -> num == null ? 0 : num - 1);
        }

        public int get(PeerId peerId) {
            return this.counter.getOrDefault(peerId, 0);
        }
    }
}

